
//Change this to true for a stretchy canvas!
//
var RESIZEABLE_CANVAS=false;

//Start us up!
//
window.onload=function( e ){

	if( RESIZEABLE_CANVAS ){
		window.onresize=function( e ){
			var canvas=document.getElementById( "GameCanvas" );

			//This vs window.innerWidth, which apparently doesn't account for scrollbar?
			var width=document.body.clientWidth;
			
			//This vs document.body.clientHeight, which does weird things - document seems to 'grow'...perhaps canvas resize pushing page down?
			var height=window.innerHeight;			

			canvas.width=width;
			canvas.height=height;
		}
		window.onresize( null );
	}

	BBMonkeyGame.Main( document.getElementById( "GameCanvas" ) );
}

//${CONFIG_BEGIN}
CFG_ANDROID_APP_LABEL="Demo";
CFG_ANDROID_APP_PACKAGE="com.purplesstudios.demo";
CFG_ANDROID_SCREEN_ORIENTATION="landscape";
CFG_ANDROID_VERSION_CODE="10";
CFG_ANDROID_VERSION_NAME="1.0";
CFG_BINARY_FILES="*.bin|*.dat|*.b3d";
CFG_BRL_GAMETARGET_IMPLEMENTED="1";
CFG_BRL_THREAD_IMPLEMENTED="1";
CFG_CD="";
CFG_CONFIG="release";
CFG_HOST="winnt";
CFG_IMAGE_FILES="*.png|*.jpg|*.gif|*.bmp";
CFG_LANG="js";
CFG_MODPATH=".;C:/Users/Ivan/Dropbox/IVAN/demo;C:/MonkeyPro/modules;C:/MonkeyPro/modules_ext;C:/MonkeyPro/targets/html5/modules";
CFG_MOJO_AUTO_SUSPEND_ENABLED="1";
CFG_MOJO_IMAGE_FILTERING_ENABLED="1";
CFG_MONKEYDIR="";
CFG_MUSIC_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_OPENGL_GLES20_ENABLED="0";
CFG_SAFEMODE="0";
CFG_SOUND_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_TARGET="html5";
CFG_TEXT_FILES="*.txt|*.xml|*.json|*.mtl|*.obj";
CFG_TRANSDIR="";
//${CONFIG_END}

//${METADATA_BEGIN}
var META_DATA="[mojo_font.png];type=image/png;width=864;height=13;\n[bgbolaacero.jpg];type=image/jpg;width=640;height=480;\n[bgburbuja.jpg];type=image/jpg;width=768;height=480;\n[bgfuego.png];type=image/png;width=640;height=480;\n[bgnubes.jpg];type=image/jpg;width=640;height=480;\n[bolaacero0.png];type=image/png;width=256;height=64;\n[bolaacero1.png];type=image/png;width=256;height=64;\n[bolaacero2.png];type=image/png;width=256;height=64;\n[bolafire.png];type=image/png;width=256;height=64;\n[bolahierro.png];type=image/png;width=256;height=64;\n[burbuja.png];type=image/png;width=256;height=64;\n[chispa.png];type=image/png;width=8;height=8;\n[fade.png];type=image/png;width=64;height=48;\n[fire0.png];type=image/png;width=128;height=128;\n[fire1.png];type=image/png;width=128;height=128;\n[fire2.png];type=image/png;width=128;height=128;\n[fire3.png];type=image/png;width=128;height=128;\n[fire4.png];type=image/png;width=128;height=128;\n[flare.png];type=image/png;width=256;height=256;\n[flash.png];type=image/png;width=64;height=48;\n[frame0.png];type=image/png;width=640;height=480;\n[frame1.png];type=image/png;width=640;height=480;\n[frame2.png];type=image/png;width=640;height=480;\n[frame3.png];type=image/png;width=640;height=480;\n[nube0.png];type=image/png;width=512;height=512;\n[nube1.png];type=image/png;width=512;height=512;\n[nube2.png];type=image/png;width=1469;height=1469;\n[nube3.png];type=image/png;width=512;height=512;\n[nube4.png];type=image/png;width=512;height=512;\n[parallax0.png];type=image/png;width=992;height=480;\n[parallax1.png];type=image/png;width=992;height=480;\n[parallax2.png];type=image/png;width=992;height=480;\n[parallax3.png];type=image/png;width=992;height=480;\n[parallax4.png];type=image/png;width=992;height=480;\n[scrollText.png];type=image/png;width=4096;height=64;\n[txt_euskal.png];type=image/png;width=640;height=480;\n[txt_icevan.png];type=image/png;width=992;height=480;\n[txt_illl.png];type=image/png;width=992;height=480;\n[txt_kba.png];type=image/png;width=992;height=480;\n[txt_mouse.png];type=image/png;width=640;height=480;\n[txt_purple.png];type=image/png;width=640;height=480;\n[txt_titulo.png];type=image/png;width=640;height=480;\n";
//${METADATA_END}

//${TRANSCODE_BEGIN}

// Javascript Monkey runtime.
//
// Placed into the public domain 24/02/2011.
// No warranty implied; use at your own risk.

//***** JavaScript Runtime *****

var D2R=0.017453292519943295;
var R2D=57.29577951308232;

var err_info="";
var err_stack=[];

var dbg_index=0;

function push_err(){
	err_stack.push( err_info );
}

function pop_err(){
	err_info=err_stack.pop();
}

function stackTrace(){
	if( !err_info.length ) return "";
	var str=err_info+"\n";
	for( var i=err_stack.length-1;i>0;--i ){
		str+=err_stack[i]+"\n";
	}
	return str;
}

function print( str ){
	var cons=document.getElementById( "GameConsole" );
	if( cons ){
		cons.value+=str+"\n";
		cons.scrollTop=cons.scrollHeight-cons.clientHeight;
	}else if( window.console!=undefined ){
		window.console.log( str );
	}
	return 0;
}

function alertError( err ){
	if( typeof(err)=="string" && err=="" ) return;
	alert( "Monkey Runtime Error : "+err.toString()+"\n\n"+stackTrace() );
}

function error( err ){
	throw err;
}

function debugLog( str ){
	if( window.console!=undefined ) window.console.log( str );
}

function debugStop(){
	debugger;	//	error( "STOP" );
}

function dbg_object( obj ){
	if( obj ) return obj;
	error( "Null object access" );
}

function dbg_charCodeAt( str,index ){
	if( index<0 || index>=str.length ) error( "Character index out of range" );
	return str.charCodeAt( index );
}

function dbg_array( arr,index ){
	if( index<0 || index>=arr.length ) error( "Array index out of range" );
	dbg_index=index;
	return arr;
}

function new_bool_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=false;
	return arr;
}

function new_number_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=0;
	return arr;
}

function new_string_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]='';
	return arr;
}

function new_array_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=[];
	return arr;
}

function new_object_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=null;
	return arr;
}

function resize_bool_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=false;
	return arr;
}

function resize_number_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=0;
	return arr;
}

function resize_string_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]="";
	return arr;
}

function resize_array_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=[];
	return arr;
}

function resize_object_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=null;
	return arr;
}

function string_compare( lhs,rhs ){
	var n=Math.min( lhs.length,rhs.length ),i,t;
	for( i=0;i<n;++i ){
		t=lhs.charCodeAt(i)-rhs.charCodeAt(i);
		if( t ) return t;
	}
	return lhs.length-rhs.length;
}

function string_replace( str,find,rep ){	//no unregex replace all?!?
	var i=0;
	for(;;){
		i=str.indexOf( find,i );
		if( i==-1 ) return str;
		str=str.substring( 0,i )+rep+str.substring( i+find.length );
		i+=rep.length;
	}
}

function string_trim( str ){
	var i=0,i2=str.length;
	while( i<i2 && str.charCodeAt(i)<=32 ) i+=1;
	while( i2>i && str.charCodeAt(i2-1)<=32 ) i2-=1;
	return str.slice( i,i2 );
}

function string_startswith( str,substr ){
	return substr.length<=str.length && str.slice(0,substr.length)==substr;
}

function string_endswith( str,substr ){
	return substr.length<=str.length && str.slice(str.length-substr.length,str.length)==substr;
}

function string_tochars( str ){
	var arr=new Array( str.length );
	for( var i=0;i<str.length;++i ) arr[i]=str.charCodeAt(i);
	return arr;
}

function string_fromchars( chars ){
	var str="",i;
	for( i=0;i<chars.length;++i ){
		str+=String.fromCharCode( chars[i] );
	}
	return str;
}

function object_downcast( obj,clas ){
	if( obj instanceof clas ) return obj;
	return null;
}

function object_implements( obj,iface ){
	if( obj && obj.implments && obj.implments[iface] ) return obj;
	return null;
}

function extend_class( clas ){
	var tmp=function(){};
	tmp.prototype=clas.prototype;
	return new tmp;
}

function ThrowableObject(){
}

ThrowableObject.prototype.toString=function(){ 
	return "Uncaught Monkey Exception"; 
}

function BBGameEvent(){}
BBGameEvent.KeyDown=1;
BBGameEvent.KeyUp=2;
BBGameEvent.KeyChar=3;
BBGameEvent.MouseDown=4;
BBGameEvent.MouseUp=5;
BBGameEvent.MouseMove=6;
BBGameEvent.TouchDown=7;
BBGameEvent.TouchUp=8;
BBGameEvent.TouchMove=9;
BBGameEvent.MotionAccel=10;

function BBGameDelegate(){}
BBGameDelegate.prototype.StartGame=function(){}
BBGameDelegate.prototype.SuspendGame=function(){}
BBGameDelegate.prototype.ResumeGame=function(){}
BBGameDelegate.prototype.UpdateGame=function(){}
BBGameDelegate.prototype.RenderGame=function(){}
BBGameDelegate.prototype.KeyEvent=function( ev,data ){}
BBGameDelegate.prototype.MouseEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.TouchEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.MotionEvent=function( ev,data,x,y,z ){}
BBGameDelegate.prototype.DiscardGraphics=function(){}

function BBGame(){
	BBGame._game=this;
	this._delegate=null;
	this._keyboardEnabled=false;
	this._updateRate=0;
	this._started=false;
	this._suspended=false;
	this._debugExs=(CFG_CONFIG=="debug");
	this._startms=Date.now();
}

BBGame.Game=function(){
	return BBGame._game;
}

BBGame.prototype.SetDelegate=function( delegate ){
	this._delegate=delegate;
}

BBGame.prototype.Delegate=function(){
	return this._delegate;
}

BBGame.prototype.SetUpdateRate=function( updateRate ){
	this._updateRate=updateRate;
}

BBGame.prototype.SetKeyboardEnabled=function( keyboardEnabled ){
	this._keyboardEnabled=keyboardEnabled;
}

BBGame.prototype.Started=function(){
	return this._started;
}

BBGame.prototype.Suspended=function(){
	return this._suspended;
}

BBGame.prototype.Millisecs=function(){
	return Date.now()-this._startms;
}

BBGame.prototype.GetDate=function( date ){
	var n=date.length;
	if( n>0 ){
		var t=new Date();
		date[0]=t.getFullYear();
		if( n>1 ){
			date[1]=t.getMonth()+1;
			if( n>2 ){
				date[2]=t.getDate();
				if( n>3 ){
					date[3]=t.getHours();
					if( n>4 ){
						date[4]=t.getMinutes();
						if( n>5 ){
							date[5]=t.getSeconds();
							if( n>6 ){
								date[6]=t.getMilliseconds();
							}
						}
					}
				}
			}
		}
	}
}

BBGame.prototype.SaveState=function( state ){
	localStorage.setItem( "monkeystate@"+document.URL,state );	//key can't start with dot in Chrome!
	return 1;
}

BBGame.prototype.LoadState=function(){
	var state=localStorage.getItem( "monkeystate@"+document.URL );
	if( state ) return state;
	return "";
}

BBGame.prototype.LoadString=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );
	
	xhr.send( null );
	
	if( xhr.status==200 || xhr.status==0 ) return xhr.responseText;
	
	return "";
}

BBGame.prototype.PollJoystick=function( port,joyx,joyy,joyz,buttons ){
	return false;
}

BBGame.prototype.OpenUrl=function( url ){
	window.location=url;
}

BBGame.prototype.SetMouseVisible=function( visible ){
	if( visible ){
		this._canvas.style.cursor='default';	
	}else{
		this._canvas.style.cursor="url('data:image/cur;base64,AAACAAEAICAAAAAAAACoEAAAFgAAACgAAAAgAAAAQAAAAAEAIAAAAAAAgBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA55ZXBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOeWVxAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADnllcGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////9////////////////////+////////f/////////8%3D'), auto";
	}
}

BBGame.prototype.PathToFilePath=function( path ){
	return "";
}

//***** js Game *****

BBGame.prototype.PathToUrl=function( path ){
	return path;
}

BBGame.prototype.LoadData=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );

	if( xhr.overrideMimeType ) xhr.overrideMimeType( "text/plain; charset=x-user-defined" );

	xhr.send( null );
	if( xhr.status!=200 && xhr.status!=0 ) return null;

	var r=xhr.responseText;
	var buf=new ArrayBuffer( r.length );
	var bytes=new Int8Array( buf );
	for( var i=0;i<r.length;++i ){
		bytes[i]=r.charCodeAt( i );
	}
	return buf;
}

//***** INTERNAL ******

BBGame.prototype.Die=function( ex ){

	this._delegate=new BBGameDelegate();
	
	if( !ex.toString() ){
		return;
	}
	
	if( this._debugExs ){
		print( "Monkey Runtime Error : "+ex.toString() );
		print( stackTrace() );
	}
	
	throw ex;
}

BBGame.prototype.StartGame=function(){

	if( this._started ) return;
	this._started=true;
	
	if( this._debugExs ){
		try{
			this._delegate.StartGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.StartGame();
	}
}

BBGame.prototype.SuspendGame=function(){

	if( !this._started || this._suspended ) return;
	this._suspended=true;
	
	if( this._debugExs ){
		try{
			this._delegate.SuspendGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.SuspendGame();
	}
}

BBGame.prototype.ResumeGame=function(){

	if( !this._started || !this._suspended ) return;
	this._suspended=false;
	
	if( this._debugExs ){
		try{
			this._delegate.ResumeGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.ResumeGame();
	}
}

BBGame.prototype.UpdateGame=function(){

	if( !this._started || this._suspended ) return;

	if( this._debugExs ){
		try{
			this._delegate.UpdateGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.UpdateGame();
	}
}

BBGame.prototype.RenderGame=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.RenderGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.RenderGame();
	}
}

BBGame.prototype.KeyEvent=function( ev,data ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.KeyEvent( ev,data );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.KeyEvent( ev,data );
	}
}

BBGame.prototype.MouseEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MouseEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MouseEvent( ev,data,x,y );
	}
}

BBGame.prototype.TouchEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.TouchEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.TouchEvent( ev,data,x,y );
	}
}

BBGame.prototype.MotionEvent=function( ev,data,x,y,z ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MotionEvent( ev,data,x,y,z );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MotionEvent( ev,data,x,y,z );
	}
}

BBGame.prototype.DiscardGraphics=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.DiscardGraphics();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.DiscardGraphics();
	}
}

function BBHtml5Game( canvas ){
	BBGame.call( this );
	BBHtml5Game._game=this;
	this._canvas=canvas;
	this._loading=0;
	this._timerSeq=0;
	this._gl=null;
	if( CFG_OPENGL_GLES20_ENABLED=="1" ){
		this._gl=this._canvas.getContext( "webgl" );
		if( !this._gl ) this._gl=this._canvas.getContext( "experimental-webgl" );
		if( !this._gl ) this.Die( "Can't create WebGL" );
		gl=this._gl;
	}
}

BBHtml5Game.prototype=extend_class( BBGame );

BBHtml5Game.Html5Game=function(){
	return BBHtml5Game._game;
}

BBHtml5Game.prototype.ValidateUpdateTimer=function(){

	++this._timerSeq;

	if( !this._updateRate || this._suspended ) return;
	
	var game=this;
	var updatePeriod=1000.0/this._updateRate;
	var nextUpdate=Date.now()+updatePeriod;
	var seq=game._timerSeq;
	
	function timeElapsed(){
		if( seq!=game._timerSeq ) return;

		var time;		
		var updates;
		
		for( updates=0;updates<4;++updates ){
		
			nextUpdate+=updatePeriod;
			
			game.UpdateGame();
			if( seq!=game._timerSeq ) return;
			
			if( nextUpdate-Date.now()>0 ) break;
		}
		
		game.RenderGame();
		if( seq!=game._timerSeq ) return;
		
		if( updates==4 ){
			nextUpdate=Date.now();
			setTimeout( timeElapsed,0 );
		}else{
			var delay=nextUpdate-Date.now();
			setTimeout( timeElapsed,delay>0 ? delay : 0 );
		}
	}

	setTimeout( timeElapsed,updatePeriod );
}

//***** BBGame methods *****

BBHtml5Game.prototype.SetUpdateRate=function( updateRate ){

	BBGame.prototype.SetUpdateRate.call( this,updateRate );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.GetMetaData=function( path,key ){
	if( path.indexOf( "monkey://data/" )!=0 ) return "";
	path=path.slice(14);

	var i=META_DATA.indexOf( "["+path+"]" );
	if( i==-1 ) return "";
	i+=path.length+2;

	var e=META_DATA.indexOf( "\n",i );
	if( e==-1 ) e=META_DATA.length;

	i=META_DATA.indexOf( ";"+key+"=",i )
	if( i==-1 || i>=e ) return "";
	i+=key.length+2;

	e=META_DATA.indexOf( ";",i );
	if( e==-1 ) return "";

	return META_DATA.slice( i,e );
}

BBHtml5Game.prototype.PathToUrl=function( path ){
	if( path.indexOf( "monkey:" )!=0 ){
		return path;
	}else if( path.indexOf( "monkey://data/" )==0 ) {
		return "data/"+path.slice( 14 );
	}
	return "";
}

BBHtml5Game.prototype.GetLoading=function(){
	return this._loading;
}

BBHtml5Game.prototype.IncLoading=function(){
	++this._loading;
	return this._loading;
}

BBHtml5Game.prototype.DecLoading=function(){
	--this._loading;
	return this._loading;
}

BBHtml5Game.prototype.GetCanvas=function(){
	return this._canvas;
}

BBHtml5Game.prototype.GetWebGL=function(){
	return this._gl;
}

//***** INTERNAL *****

BBHtml5Game.prototype.UpdateGame=function(){

	if( !this._loading ) BBGame.prototype.UpdateGame.call( this );
}

BBHtml5Game.prototype.SuspendGame=function(){

	BBGame.prototype.SuspendGame.call( this );
	
	BBGame.prototype.RenderGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.ResumeGame=function(){

	BBGame.prototype.ResumeGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.Run=function(){

	var game=this;
	var canvas=game._canvas;
	
	var touchIds=new Array( 32 );
	for( i=0;i<32;++i ) touchIds[i]=-1;
	
	function eatEvent( e ){
		if( e.stopPropagation ){
			e.stopPropagation();
			e.preventDefault();
		}else{
			e.cancelBubble=true;
			e.returnValue=false;
		}
	}
	
	function keyToChar( key ){
		switch( key ){
		case 8:case 9:case 13:case 27:case 32:return key;
		case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 45:return key|0x10000;
		case 46:return 127;
		}
		return 0;
	}
	
	function mouseX( e ){
		var x=e.clientX+document.body.scrollLeft;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x;
	}
	
	function mouseY( e ){
		var y=e.clientY+document.body.scrollTop;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y;
	}

	function touchX( touch ){
		var x=touch.pageX;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x;
	}			
	
	function touchY( touch ){
		var y=touch.pageY;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y;
	}
	
	canvas.onkeydown=function( e ){
		game.KeyEvent( BBGameEvent.KeyDown,e.keyCode );
		var chr=keyToChar( e.keyCode );
		if( chr ) game.KeyEvent( BBGameEvent.KeyChar,chr );
		if( e.keyCode<48 || (e.keyCode>111 && e.keyCode<122) ) eatEvent( e );
	}

	canvas.onkeyup=function( e ){
		game.KeyEvent( BBGameEvent.KeyUp,e.keyCode );
	}

	canvas.onkeypress=function( e ){
		if( e.charCode ){
			game.KeyEvent( BBGameEvent.KeyChar,e.charCode );
		}else if( e.which ){
			game.KeyEvent( BBGameEvent.KeyChar,e.which );
		}
	}

	canvas.onmousedown=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseDown,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseDown,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseDown,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmouseup=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmousemove=function( e ){
		game.MouseEvent( BBGameEvent.MouseMove,-1,mouseX(e),mouseY(e) );
		eatEvent( e );
	}

	canvas.onmouseout=function( e ){
		game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );
		eatEvent( e );
	}

	canvas.ontouchstart=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=-1 ) continue;
				touchIds[j]=touch.identifier;
				game.TouchEvent( BBGameEvent.TouchDown,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchmove=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				game.TouchEvent( BBGameEvent.TouchMove,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchend=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				touchIds[j]=-1;
				game.TouchEvent( BBGameEvent.TouchUp,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	window.ondevicemotion=function( e ){
		var tx=e.accelerationIncludingGravity.x/9.81;
		var ty=e.accelerationIncludingGravity.y/9.81;
		var tz=e.accelerationIncludingGravity.z/9.81;
		var x,y;
		switch( window.orientation ){
		case   0:x=+tx;y=-ty;break;
		case 180:x=-tx;y=+ty;break;
		case  90:x=-ty;y=-tx;break;
		case -90:x=+ty;y=+tx;break;
		}
		game.MotionEvent( BBGameEvent.MotionAccel,0,x,y,tz );
		eatEvent( e );
	}

	canvas.onfocus=function( e ){
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.ResumeGame();
		}
	}
	
	canvas.onblur=function( e ){
		for( var i=0;i<256;++i ) game.KeyEvent( BBGameEvent.KeyUp,i );
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.SuspendGame();
		}
	}
	
	canvas.focus();
	
	game.StartGame();

	game.RenderGame();
}

function BBMonkeyGame( canvas ){
	BBHtml5Game.call( this,canvas );
}

BBMonkeyGame.prototype=extend_class( BBHtml5Game );

BBMonkeyGame.Main=function( canvas ){

	var game=new BBMonkeyGame( canvas );

	try{

		bbInit();
		bbMain();

	}catch( ex ){
	
		game.Die( ex );
		return;
	}

	if( !game.Delegate() ) return;
	
	game.Run();
}

// HTML5 mojo runtime.
//
// Copyright 2011 Mark Sibly, all rights reserved.
// No warranty implied; use at your own risk.

//***** gxtkGraphics class *****

function gxtkGraphics(){
	this.game=BBHtml5Game.Html5Game();
	this.canvas=this.game.GetCanvas()
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	this.gl=null;
	this.gc=this.canvas.getContext( '2d' );
	this.tmpCanvas=null;
	this.r=255;
	this.b=255;
	this.g=255;
	this.white=true;
	this.color="rgb(255,255,255)"
	this.alpha=1;
	this.blend="source-over";
	this.ix=1;this.iy=0;
	this.jx=0;this.jy=1;
	this.tx=0;this.ty=0;
	this.tformed=false;
	this.scissorX=0;
	this.scissorY=0;
	this.scissorWidth=0;
	this.scissorHeight=0;
	this.clipped=false;
}

gxtkGraphics.prototype.BeginRender=function(){
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	if( !this.gc ) return 0;
	this.gc.save();
	if( this.game.GetLoading() ) return 2;
	return 1;
}

gxtkGraphics.prototype.EndRender=function(){
	if( this.gc ) this.gc.restore();
}

gxtkGraphics.prototype.Width=function(){
	return this.width;
}

gxtkGraphics.prototype.Height=function(){
	return this.height;
}

gxtkGraphics.prototype.LoadSurface=function( path ){
	var game=this.game;

	var ty=game.GetMetaData( path,"type" );
	if( ty.indexOf( "image/" )!=0 ) return null;
	
	function onloadfun(){
		game.DecLoading();
	}
	
	game.IncLoading();

	var image=new Image();
	image.onload=onloadfun;
	image.meta_width=parseInt( game.GetMetaData( path,"width" ) );
	image.meta_height=parseInt( game.GetMetaData( path,"height" ) );
	image.src=game.PathToUrl( path );

	return new gxtkSurface( image,this );
}

gxtkGraphics.prototype.CreateSurface=function( width,height ){
	var canvas=document.createElement( 'canvas' );
	
	canvas.width=width;
	canvas.height=height;
	canvas.meta_width=width;
	canvas.meta_height=height;
	canvas.complete=true;
	
	var surface=new gxtkSurface( canvas,this );
	
	surface.gc=canvas.getContext( '2d' );
	
	return surface;
}

gxtkGraphics.prototype.SetAlpha=function( alpha ){
	this.alpha=alpha;
	this.gc.globalAlpha=alpha;
}

gxtkGraphics.prototype.SetColor=function( r,g,b ){
	this.r=r;
	this.g=g;
	this.b=b;
	this.white=(r==255 && g==255 && b==255);
	this.color="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;
}

gxtkGraphics.prototype.SetBlend=function( blend ){
	switch( blend ){
	case 1:
		this.blend="lighter";
		break;
	default:
		this.blend="source-over";
	}
	this.gc.globalCompositeOperation=this.blend;
}

gxtkGraphics.prototype.SetScissor=function( x,y,w,h ){
	this.scissorX=x;
	this.scissorY=y;
	this.scissorWidth=w;
	this.scissorHeight=h;
	this.clipped=(x!=0 || y!=0 || w!=this.canvas.width || h!=this.canvas.height);
	this.gc.restore();
	this.gc.save();
	if( this.clipped ){
		this.gc.beginPath();
		this.gc.rect( x,y,w,h );
		this.gc.clip();
		this.gc.closePath();
	}
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;	
	this.gc.globalAlpha=this.alpha;	
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.SetMatrix=function( ix,iy,jx,jy,tx,ty ){
	this.ix=ix;this.iy=iy;
	this.jx=jx;this.jy=jy;
	this.tx=tx;this.ty=ty;
	this.gc.setTransform( ix,iy,jx,jy,tx,ty );
	this.tformed=(ix!=1 || iy!=0 || jx!=0 || jy!=1 || tx!=0 || ty!=0);
}

gxtkGraphics.prototype.Cls=function( r,g,b ){
	if( this.tformed ) this.gc.setTransform( 1,0,0,1,0,0 );
	this.gc.fillStyle="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.globalAlpha=1;
	this.gc.globalCompositeOperation="source-over";
	this.gc.fillRect( 0,0,this.canvas.width,this.canvas.height );
	this.gc.fillStyle=this.color;
	this.gc.globalAlpha=this.alpha;
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.DrawPoint=function( x,y ){
	if( this.tformed ){
		var px=x;
		x=px * this.ix + y * this.jx + this.tx;
		y=px * this.iy + y * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
		this.gc.fillRect( x,y,1,1 );
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
		this.gc.fillRect( x,y,1,1 );
	}
}

gxtkGraphics.prototype.DrawRect=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
	this.gc.fillRect( x,y,w,h );
}

gxtkGraphics.prototype.DrawLine=function( x1,y1,x2,y2 ){
	if( this.tformed ){
		var x1_t=x1 * this.ix + y1 * this.jx + this.tx;
		var y1_t=x1 * this.iy + y1 * this.jy + this.ty;
		var x2_t=x2 * this.ix + y2 * this.jx + this.tx;
		var y2_t=x2 * this.iy + y2 * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1_t,y1_t );
	  	this.gc.lineTo( x2_t,y2_t );
	  	this.gc.stroke();
	  	this.gc.closePath();
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1,y1 );
	  	this.gc.lineTo( x2,y2 );
	  	this.gc.stroke();
	  	this.gc.closePath();
	}
}

gxtkGraphics.prototype.DrawOval=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
  	var w2=w/2,h2=h/2;
	this.gc.save();
	this.gc.translate( x+w2,y+h2 );
	this.gc.scale( w2,h2 );
  	this.gc.beginPath();
	this.gc.arc( 0,0,1,0,Math.PI*2,false );
	this.gc.fill();
  	this.gc.closePath();
	this.gc.restore();
}

gxtkGraphics.prototype.DrawPoly=function( verts ){
	if( verts.length<2 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=2;i<verts.length;i+=2 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawPoly2=function( verts,surface,srx,srcy ){
	if( verts.length<4 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=4;i<verts.length;i+=4 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawSurface=function( surface,x,y ){
	if( !surface.image.complete ) return;
	
	if( this.white ){
		this.gc.drawImage( surface.image,x,y );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,0,0,surface.swidth,surface.sheight );
}

gxtkGraphics.prototype.DrawSurface2=function( surface,x,y,srcx,srcy,srcw,srch ){
	if( !surface.image.complete ) return;

	if( srcw<0 ){ srcx+=srcw;srcw=-srcw; }
	if( srch<0 ){ srcy+=srch;srch=-srch; }
	if( srcw<=0 || srch<=0 ) return;

	if( this.white ){
		this.gc.drawImage( surface.image,srcx,srcy,srcw,srch,x,y,srcw,srch );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,srcx,srcy,srcw,srch  );
}

gxtkGraphics.prototype.DrawImageTinted=function( image,dx,dy,sx,sy,sw,sh ){

	if( !this.tmpCanvas ){
		this.tmpCanvas=document.createElement( "canvas" );
	}

	if( sw>this.tmpCanvas.width || sh>this.tmpCanvas.height ){
		this.tmpCanvas.width=Math.max( sw,this.tmpCanvas.width );
		this.tmpCanvas.height=Math.max( sh,this.tmpCanvas.height );
	}
	
	var tmpGC=this.tmpCanvas.getContext( "2d" );
	tmpGC.globalCompositeOperation="copy";
	
	tmpGC.drawImage( image,sx,sy,sw,sh,0,0,sw,sh );
	
	var imgData=tmpGC.getImageData( 0,0,sw,sh );
	
	var p=imgData.data,sz=sw*sh*4,i;
	
	for( i=0;i<sz;i+=4 ){
		p[i]=p[i]*this.r/255;
		p[i+1]=p[i+1]*this.g/255;
		p[i+2]=p[i+2]*this.b/255;
	}
	
	tmpGC.putImageData( imgData,0,0 );
	
	this.gc.drawImage( this.tmpCanvas,0,0,sw,sh,dx,dy,sw,sh );
}

gxtkGraphics.prototype.ReadPixels=function( pixels,x,y,width,height,offset,pitch ){

	var imgData=this.gc.getImageData( x,y,width,height );
	
	var p=imgData.data,i=0,j=offset,px,py;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			pixels[j++]=(p[i+3]<<24)|(p[i]<<16)|(p[i+1]<<8)|p[i+2];
			i+=4;
		}
		j+=pitch-width;
	}
}

gxtkGraphics.prototype.WritePixels2=function( surface,pixels,x,y,width,height,offset,pitch ){

	if( !surface.gc ){
		if( !surface.image.complete ) return;
		var canvas=document.createElement( "canvas" );
		canvas.width=surface.swidth;
		canvas.height=surface.sheight;
		surface.gc=canvas.getContext( "2d" );
		surface.gc.globalCompositeOperation="copy";
		surface.gc.drawImage( surface.image,0,0 );
		surface.image=canvas;
	}

	var imgData=surface.gc.createImageData( width,height );

	var p=imgData.data,i=0,j=offset,px,py,argb;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			argb=pixels[j++];
			p[i]=(argb>>16) & 0xff;
			p[i+1]=(argb>>8) & 0xff;
			p[i+2]=argb & 0xff;
			p[i+3]=(argb>>24) & 0xff;
			i+=4;
		}
		j+=pitch-width;
	}
	
	surface.gc.putImageData( imgData,x,y );
}

//***** gxtkSurface class *****

function gxtkSurface( image,graphics ){
	this.image=image;
	this.graphics=graphics;
	this.swidth=image.meta_width;
	this.sheight=image.meta_height;
}

//***** GXTK API *****

gxtkSurface.prototype.Discard=function(){
	if( this.image ){
		this.image=null;
	}
}

gxtkSurface.prototype.Width=function(){
	return this.swidth;
}

gxtkSurface.prototype.Height=function(){
	return this.sheight;
}

gxtkSurface.prototype.Loaded=function(){
	return this.image.complete;
}

gxtkSurface.prototype.OnUnsafeLoadComplete=function(){
	return true;
}

//***** gxtkChannel class *****
function gxtkChannel(){
	this.sample=null;
	this.audio=null;
	this.volume=1;
	this.pan=0;
	this.rate=1;
	this.flags=0;
	this.state=0;
}

//***** gxtkAudio class *****
function gxtkAudio(){
	this.game=BBHtml5Game.Html5Game();
	this.okay=typeof(Audio)!="undefined";
	this.music=null;
	this.channels=new Array(33);
	for( var i=0;i<33;++i ){
		this.channels[i]=new gxtkChannel();
		if( !this.okay ) this.channels[i].state=-1;
	}
}

gxtkAudio.prototype.Suspend=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ) chan.audio.pause();
	}
}

gxtkAudio.prototype.Resume=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ) chan.audio.play();
	}
}

gxtkAudio.prototype.LoadSample=function( path ){
	if( !this.okay ) return null;

	var audio=new Audio( this.game.PathToUrl( path ) );
	if( !audio ) return null;
	
	return new gxtkSample( audio );
}

gxtkAudio.prototype.PlaySample=function( sample,channel,flags ){
	if( !this.okay ) return;
	
	var chan=this.channels[channel];

	if( chan.state>0 ){
		chan.audio.pause();
		chan.state=0;
	}
	
	for( var i=0;i<33;++i ){
		var chan2=this.channels[i];
		if( chan2.state==1 && chan2.audio.ended && !chan2.audio.loop ) chan.state=0;
		if( chan2.state==0 && chan2.sample ){
			chan2.sample.FreeAudio( chan2.audio );
			chan2.sample=null;
			chan2.audio=null;
		}
	}

	var audio=sample.AllocAudio();
	if( !audio ) return;

	audio.loop=(flags&1)!=0;
	audio.volume=chan.volume;
	audio.play();

	chan.sample=sample;
	chan.audio=audio;
	chan.flags=flags;
	chan.state=1;
}

gxtkAudio.prototype.StopChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state>0 ){
		chan.audio.pause();
		chan.state=0;
	}
}

gxtkAudio.prototype.PauseChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==1 ){
		if( chan.audio.ended && !chan.audio.loop ){
			chan.state=0;
		}else{
			chan.audio.pause();
			chan.state=2;
		}
	}
}

gxtkAudio.prototype.ResumeChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==2 ){
		chan.audio.play();
		chan.state=1;
	}
}

gxtkAudio.prototype.ChannelState=function( channel ){
	var chan=this.channels[channel];
	if( chan.state==1 && chan.audio.ended && !chan.audio.loop ) chan.state=0;
	return chan.state;
}

gxtkAudio.prototype.SetVolume=function( channel,volume ){
	var chan=this.channels[channel];
	if( chan.state>0 ) chan.audio.volume=volume;
	chan.volume=volume;
}

gxtkAudio.prototype.SetPan=function( channel,pan ){
	var chan=this.channels[channel];
	chan.pan=pan;
}

gxtkAudio.prototype.SetRate=function( channel,rate ){
	var chan=this.channels[channel];
	chan.rate=rate;
}

gxtkAudio.prototype.PlayMusic=function( path,flags ){
	this.StopMusic();
	
	this.music=this.LoadSample( path );
	if( !this.music ) return;
	
	this.PlaySample( this.music,32,flags );
}

gxtkAudio.prototype.StopMusic=function(){
	this.StopChannel( 32 );

	if( this.music ){
		this.music.Discard();
		this.music=null;
	}
}

gxtkAudio.prototype.PauseMusic=function(){
	this.PauseChannel( 32 );
}

gxtkAudio.prototype.ResumeMusic=function(){
	this.ResumeChannel( 32 );
}

gxtkAudio.prototype.MusicState=function(){
	return this.ChannelState( 32 );
}

gxtkAudio.prototype.SetMusicVolume=function( volume ){
	this.SetVolume( 32,volume );
}

//***** gxtkSample class *****

function gxtkSample( audio ){
	this.audio=audio;
	this.free=new Array();
	this.insts=new Array();
}

gxtkSample.prototype.FreeAudio=function( audio ){
	this.free.push( audio );
}

gxtkSample.prototype.AllocAudio=function(){
	var audio;
	while( this.free.length ){
		audio=this.free.pop();
		try{
			audio.currentTime=0;
			return audio;
		}catch( ex ){
			print( "AUDIO ERROR1!" );
		}
	}
	
	//Max out?
	if( this.insts.length==8 ) return null;
	
	audio=new Audio( this.audio.src );
	
	//yucky loop handler for firefox!
	//
	audio.addEventListener( 'ended',function(){
		if( this.loop ){
			try{
				this.currentTime=0;
				this.play();
			}catch( ex ){
				print( "AUDIO ERROR2!" );
			}
		}
	},false );

	this.insts.push( audio );
	return audio;
}

gxtkSample.prototype.Discard=function(){
}

function BBThread(){
	this.result=null;
	this.running=false;
}

BBThread.prototype.Start=function(){
	this.result=null;
	this.running=true;
	this.Run__UNSAFE__();
}

BBThread.prototype.IsRunning=function(){
	return this.running;
}

BBThread.prototype.Result=function(){
	return this.result;
}

BBThread.prototype.Run__UNSAFE__=function(){
	this.running=false;
}

function BBAsyncImageLoaderThread(){
	BBThread.call(this);
}

BBAsyncImageLoaderThread.prototype=extend_class( BBThread );

BBAsyncImageLoaderThread.prototype.Start=function(){

	var thread=this;

	var image=new Image();
	
	image.onload=function( e ){
		image.meta_width=image.width;
		image.meta_height=image.height;
		thread._surface=new gxtkSurface( image,thread._device )
		thread.running=false;
	}
	
	image.onerror=function( e ){
		thread._surface=null;
		thread.running=false;
	}
	
	thread.running=true;
	
	image.src=BBGame.Game().PathToUrl( thread._path );
}


function BBAsyncSoundLoaderThread(){
	BBThread.call(this);
}

BBAsyncSoundLoaderThread.prototype=extend_class( BBThread );

BBAsyncSoundLoaderThread.prototype.Start=function(){
	this._sample=this._device.LoadSample( this._path );
}
var musicPlayer = new Object();


musicPlayer.setPosition=function(timeMillis)
{
	if(bb_audio_device &&
		bb_audio_device.channels &&
		bb_audio_device.channels[32] &&
		bb_audio_device.channels[32].audio)
	{
		var audio = bb_audio_device.channels[32].audio;
		try {
			audio.currentTime = timeMillis/1000.0;
			return 1;
		} catch(e) {}
	}
	return 0;
};

musicPlayer.getPosition=function()
{
	if(bb_audio_device &&
		bb_audio_device.channels &&
		bb_audio_device.channels[32] &&
		bb_audio_device.channels[32].audio)
	{
		var audio = bb_audio_device.channels[32].audio;
		try {
			
			return audio.currentTime * 1000;
		} catch(e) {}
	}
	return 0;
};

musicPlayer.getDuration = function()
{
	if(bb_audio_device &&
		bb_audio_device.channels &&
		bb_audio_device.channels[32] &&
		bb_audio_device.channels[32].audio)
	{
		var audio = bb_audio_device.channels[32].audio;
		try {
			
			return audio.duration * 1000;
		} catch(e) {}
	}
	return 0;

};function c_App(){
	Object.call(this);
}
c_App.m_new=function(){
	if((bb_app__app)!=null){
		error("App has already been created");
	}
	bb_app__app=this;
	bb_app__delegate=c_GameDelegate.m_new.call(new c_GameDelegate);
	bb_app__game.SetDelegate(bb_app__delegate);
	return this;
}
c_App.prototype.p_OnCreate=function(){
	return 0;
}
c_App.prototype.p_OnSuspend=function(){
	return 0;
}
c_App.prototype.p_OnResume=function(){
	return 0;
}
c_App.prototype.p_OnUpdate=function(){
	return 0;
}
c_App.prototype.p_OnLoading=function(){
	return 0;
}
c_App.prototype.p_OnRender=function(){
	return 0;
}
c_App.prototype.p_OnClose=function(){
	bb_app_EndApp();
	return 0;
}
c_App.prototype.p_OnBack=function(){
	this.p_OnClose();
	return 0;
}
function c_Demo(){
	c_App.call(this);
	this.m_fade=null;
	this.m_burbujas=null;
	this.m_fondoMar=null;
	this.m_event=0;
	this.m_events=[876,1474,1896,2966];
	this.m_titlealfa=0.0;
	this.m_fire=null;
	this.m_nubes=null;
	this.m_tunnel=null;
	this.m_toro=null;
	this.m_parallax=null;
	this.m_purplealfa=0.0;
}
c_Demo.prototype=extend_class(c_App);
c_Demo.m_new=function(){
	c_App.m_new.call(this);
	return this;
}
c_Demo.prototype.p_OnCreate=function(){
	c_Display.m_Init(640.0,480.0,60.0,-1,-1,true);
	bb_random_Seed=0;
	c_Camera3D.m_Init(c_Vec2.m_new.call(new c_Vec2,c_Display.m_w/2.0,c_Display.m_h/2.0),500.0);
	c_Camera3D.m_SetFocus(100.0,50.0);
	c_Assets.m_Load();
	this.m_fade=c_Fade.m_new.call(new c_Fade);
	return 0;
}
c_Demo.m_estado="";
c_Demo.prototype.p_OnUpdate=function(){
	this.m_fade.p_Update();
	c_Camera3D.m_dist=c_Camera3D.m_dist+(bb_input_KeyDown(65)-bb_input_KeyDown(90));
	var t_1=c_Demo.m_estado;
	if(t_1=="start"){
		if((bb_input_MouseHit(0))!=0){
			bb_audio_PlayMusic("music.mp3",0);
			c_Demo.m_estado="scene0";
			this.m_burbujas=c_StarField.m_new.call(new c_StarField,[c_Assets.m_img_burbuja],c_Assets.m_data_64f,0.5,400);
			this.m_fondoMar=c_Calima.m_new.call(new c_Calima,c_Assets.m_img_bgburbuja,120);
		}
	}else{
		if(t_1=="scene0"){
			if(((bb_input_KeyHit(81))!=0) || c_Display.m_t>=172){
				c_Demo.m_estado="scene1";
				this.m_fade.p_Set3(0.005,"in");
			}
		}else{
			if(t_1=="scene1"){
				this.m_fondoMar.p_Update();
				this.m_burbujas.p_Update();
				if(this.m_event==0 && c_Display.m_t>=this.m_events[0]){
					this.m_fade.p_Set3(0.025,"out");
					this.m_event+=1;
				}
				if(c_Display.m_t>=401){
					this.m_titlealfa+=(1.0-this.m_titlealfa)/5.0;
				}
				if(((bb_input_KeyHit(81))!=0) || c_Display.m_t>=935){
					c_Demo.m_estado="scene2";
					c_Sprite3D.m_DestroyAll();
					this.m_fire=c_FireObject.m_new.call(new c_FireObject,c_Assets.m_obj_fireball,c_Assets.m_img_bolafire,c_Assets.m_data_64f,c_Assets.m_img_fire,c_Assets.m_data_128,c_Assets.m_img_chispa,c_Assets.m_data_8);
					this.m_fade.p_Set3(0.005,"in");
				}
			}else{
				if(t_1=="scene2"){
					this.m_fire.p_Update();
					if(this.m_event==1 && c_Display.m_t>=this.m_events[1]){
						this.m_fade.p_Set3(0.025,"out");
						this.m_event+=1;
					}
					if(((bb_input_KeyHit(81))!=0) || c_Display.m_t>=1573){
						c_Demo.m_estado="scene3";
						c_Sprite3D.m_DestroyAll();
						this.m_nubes=c_Coulds.m_new.call(new c_Coulds,c_Assets.m_img_nube,c_Assets.m_data_512,0.05,400);
						this.m_tunnel=c_Tunnel.m_new.call(new c_Tunnel,c_Assets.m_img_bolaacero,c_Assets.m_data_64f);
						this.m_fade.p_Set3(0.005,"in");
					}
				}else{
					if(t_1=="scene3"){
						this.m_nubes.p_Update();
						this.m_tunnel.p_Update();
						if(this.m_event==2 && c_Display.m_t>=this.m_events[2]){
							this.m_fade.p_Set3(0.025,"out");
							this.m_event+=1;
						}
						if(((bb_input_KeyHit(81))!=0) || c_Display.m_t>=1948){
							c_Demo.m_estado="scene4";
							c_Sprite3D.m_DestroyAll();
							this.m_toro=c_Toro.m_new.call(new c_Toro);
							this.m_parallax=c_Parallax.m_new.call(new c_Parallax,c_Assets.m_img_parallax,[c_Assets.m_txt_icevan,c_Assets.m_txt_kba,c_Assets.m_txt_illl]);
							this.m_fade.p_Set3(0.005,"in");
						}
					}else{
						if(t_1=="scene4"){
							this.m_parallax.p_Update();
							this.m_toro.p_Update();
							if(this.m_event==3 && c_Display.m_t>=this.m_events[3]){
								this.m_fade.p_Set3(0.0125,"out");
								this.m_event+=1;
							}
							if(c_Display.m_t>=2965){
								this.m_purplealfa+=(1.0-this.m_purplealfa)/25.0;
							}
						}
					}
				}
			}
		}
	}
	c_Object3D.m_UpdateAll();
	return 0;
}
c_Demo.prototype.p_OnRender=function(){
	c_Display.m_Update();
	var t_2=c_Demo.m_estado;
	if(t_2=="start"){
		bb_graphics_Cls(0.0,0.0,0.0);
		bb_graphics_DrawImage(c_Assets.m_txt_mouse,0.0,0.0,0);
	}else{
		if(t_2=="scene0"){
			bb_graphics_Cls(0.0,0.0,0.0);
			bb_graphics_DrawImage(c_Assets.m_txt_euskal,0.0,0.0,0);
		}else{
			if(t_2=="scene1"){
				this.m_fondoMar.p_Draw();
				c_Sprite3D.m_RenderAll();
				bb_graphics_DrawImage(c_Assets.m_img_frame[0],0.0,0.0,0);
				bb_graphics_SetAlpha(this.m_titlealfa);
				bb_graphics_DrawImage(c_Assets.m_txt_titulo,0.0,0.0,0);
				bb_graphics_SetAlpha(1.0);
			}else{
				if(t_2=="scene2"){
					bb_graphics_SetAlpha(0.5);
					if(bb_random_Rnd2(0.0,100.0)<2.0){
						bb_graphics_SetBlend(1);
					}
					bb_graphics_DrawImage(c_Assets.m_img_bgfuego,0.0,0.0,0);
					bb_graphics_SetAlpha(1.0);
					bb_graphics_SetBlend(0);
					c_Sprite3D.m_RenderAll();
					bb_graphics_DrawImage(c_Assets.m_img_frame[1],0.0,0.0,0);
				}else{
					if(t_2=="scene3"){
						bb_graphics_Cls(255.0,0.0,0.0);
						bb_graphics_DrawImage(c_Assets.m_img_bgnubes,0.0,0.0,0);
						c_Sprite3D.m_RenderAll();
						bb_graphics_DrawImage(c_Assets.m_img_frame[2],0.0,0.0,0);
					}else{
						if(t_2=="scene4"){
							this.m_parallax.p_Draw();
							c_Sprite3D.m_RenderAll();
							bb_graphics_DrawImage(c_Assets.m_img_frame[3],0.0,0.0,0);
						}else{
							if(t_2=="end"){
								bb_graphics_Cls(0.0,0.0,0.0);
							}
						}
					}
				}
			}
		}
	}
	this.m_fade.p_Draw();
	bb_graphics_SetAlpha(this.m_purplealfa);
	bb_graphics_DrawImage(c_Assets.m_txt_purple,0.0,0.0,0);
	bb_graphics_SetAlpha(1.0);
	return 0;
}
c_Demo.prototype.p_OnBack=function(){
	return 0;
}
c_Demo.prototype.p_OnClose=function(){
	return 0;
}
c_Demo.prototype.p_OnLoading=function(){
	return 0;
}
c_Demo.prototype.p_OnResume=function(){
	return 0;
}
c_Demo.prototype.p_OnSuspend=function(){
	return 0;
}
var bb_app__app=null;
function c_GameDelegate(){
	BBGameDelegate.call(this);
	this.m__graphics=null;
	this.m__audio=null;
	this.m__input=null;
}
c_GameDelegate.prototype=extend_class(BBGameDelegate);
c_GameDelegate.m_new=function(){
	return this;
}
c_GameDelegate.prototype.StartGame=function(){
	this.m__graphics=(new gxtkGraphics);
	bb_graphics_SetGraphicsDevice(this.m__graphics);
	bb_graphics_SetFont(null,32);
	this.m__audio=(new gxtkAudio);
	bb_audio_SetAudioDevice(this.m__audio);
	this.m__input=c_InputDevice.m_new.call(new c_InputDevice);
	bb_input_SetInputDevice(this.m__input);
	bb_app__app.p_OnCreate();
}
c_GameDelegate.prototype.SuspendGame=function(){
	bb_app__app.p_OnSuspend();
	this.m__audio.Suspend();
}
c_GameDelegate.prototype.ResumeGame=function(){
	this.m__audio.Resume();
	bb_app__app.p_OnResume();
}
c_GameDelegate.prototype.UpdateGame=function(){
	this.m__input.p_BeginUpdate();
	bb_app__app.p_OnUpdate();
	this.m__input.p_EndUpdate();
}
c_GameDelegate.prototype.RenderGame=function(){
	var t_mode=this.m__graphics.BeginRender();
	if((t_mode)!=0){
		bb_graphics_BeginRender();
	}
	if(t_mode==2){
		bb_app__app.p_OnLoading();
	}else{
		bb_app__app.p_OnRender();
	}
	if((t_mode)!=0){
		bb_graphics_EndRender();
	}
	this.m__graphics.EndRender();
}
c_GameDelegate.prototype.KeyEvent=function(t_event,t_data){
	this.m__input.p_KeyEvent(t_event,t_data);
	if(t_event!=1){
		return;
	}
	var t_1=t_data;
	if(t_1==432){
		bb_app__app.p_OnClose();
	}else{
		if(t_1==416){
			bb_app__app.p_OnBack();
		}
	}
}
c_GameDelegate.prototype.MouseEvent=function(t_event,t_data,t_x,t_y){
	this.m__input.p_MouseEvent(t_event,t_data,t_x,t_y);
}
c_GameDelegate.prototype.TouchEvent=function(t_event,t_data,t_x,t_y){
	this.m__input.p_TouchEvent(t_event,t_data,t_x,t_y);
}
c_GameDelegate.prototype.MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	this.m__input.p_MotionEvent(t_event,t_data,t_x,t_y,t_z);
}
c_GameDelegate.prototype.DiscardGraphics=function(){
	this.m__graphics.DiscardGraphics();
}
var bb_app__delegate=null;
var bb_app__game=null;
function bbMain(){
	c_Demo.m_new.call(new c_Demo);
	return 0;
}
var bb_graphics_device=null;
function bb_graphics_SetGraphicsDevice(t_dev){
	bb_graphics_device=t_dev;
	return 0;
}
function c_Image(){
	Object.call(this);
	this.m_surface=null;
	this.m_width=0;
	this.m_height=0;
	this.m_frames=[];
	this.m_flags=0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_source=null;
}
c_Image.m_DefaultFlags=0;
c_Image.m_new=function(){
	return this;
}
c_Image.prototype.p_SetHandle=function(t_tx,t_ty){
	this.m_tx=t_tx;
	this.m_ty=t_ty;
	this.m_flags=this.m_flags&-2;
	return 0;
}
c_Image.prototype.p_ApplyFlags=function(t_iflags){
	this.m_flags=t_iflags;
	if((this.m_flags&2)!=0){
		var t_=this.m_frames;
		var t_2=0;
		while(t_2<t_.length){
			var t_f=t_[t_2];
			t_2=t_2+1;
			t_f.m_x+=1;
		}
		this.m_width-=2;
	}
	if((this.m_flags&4)!=0){
		var t_3=this.m_frames;
		var t_4=0;
		while(t_4<t_3.length){
			var t_f2=t_3[t_4];
			t_4=t_4+1;
			t_f2.m_y+=1;
		}
		this.m_height-=2;
	}
	if((this.m_flags&1)!=0){
		this.p_SetHandle((this.m_width)/2.0,(this.m_height)/2.0);
	}
	if(this.m_frames.length==1 && this.m_frames[0].m_x==0 && this.m_frames[0].m_y==0 && this.m_width==this.m_surface.Width() && this.m_height==this.m_surface.Height()){
		this.m_flags|=65536;
	}
	return 0;
}
c_Image.prototype.p_Init=function(t_surf,t_nframes,t_iflags){
	this.m_surface=t_surf;
	this.m_width=((this.m_surface.Width()/t_nframes)|0);
	this.m_height=this.m_surface.Height();
	this.m_frames=new_object_array(t_nframes);
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		this.m_frames[t_i]=c_Frame.m_new.call(new c_Frame,t_i*this.m_width,0);
	}
	this.p_ApplyFlags(t_iflags);
	return this;
}
c_Image.prototype.p_Grab=function(t_x,t_y,t_iwidth,t_iheight,t_nframes,t_iflags,t_source){
	this.m_source=t_source;
	this.m_surface=t_source.m_surface;
	this.m_width=t_iwidth;
	this.m_height=t_iheight;
	this.m_frames=new_object_array(t_nframes);
	var t_ix=t_x;
	var t_iy=t_y;
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		if(t_ix+this.m_width>t_source.m_width){
			t_ix=0;
			t_iy+=this.m_height;
		}
		if(t_ix+this.m_width>t_source.m_width || t_iy+this.m_height>t_source.m_height){
			error("Image frame outside surface");
		}
		this.m_frames[t_i]=c_Frame.m_new.call(new c_Frame,t_ix+t_source.m_frames[0].m_x,t_iy+t_source.m_frames[0].m_y);
		t_ix+=this.m_width;
	}
	this.p_ApplyFlags(t_iflags);
	return this;
}
c_Image.prototype.p_GrabImage=function(t_x,t_y,t_width,t_height,t_frames,t_flags){
	if(this.m_frames.length!=1){
		return null;
	}
	return (c_Image.m_new.call(new c_Image)).p_Grab(t_x,t_y,t_width,t_height,t_frames,t_flags,this);
}
c_Image.prototype.p_Width=function(){
	return this.m_width;
}
c_Image.prototype.p_Height=function(){
	return this.m_height;
}
function c_GraphicsContext(){
	Object.call(this);
	this.m_defaultFont=null;
	this.m_font=null;
	this.m_firstChar=0;
	this.m_matrixSp=0;
	this.m_ix=1.0;
	this.m_iy=.0;
	this.m_jx=.0;
	this.m_jy=1.0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_tformed=0;
	this.m_matDirty=0;
	this.m_color_r=.0;
	this.m_color_g=.0;
	this.m_color_b=.0;
	this.m_alpha=.0;
	this.m_blend=0;
	this.m_scissor_x=.0;
	this.m_scissor_y=.0;
	this.m_scissor_width=.0;
	this.m_scissor_height=.0;
	this.m_matrixStack=new_number_array(192);
}
c_GraphicsContext.m_new=function(){
	return this;
}
c_GraphicsContext.prototype.p_Validate=function(){
	if((this.m_matDirty)!=0){
		bb_graphics_renderDevice.SetMatrix(bb_graphics_context.m_ix,bb_graphics_context.m_iy,bb_graphics_context.m_jx,bb_graphics_context.m_jy,bb_graphics_context.m_tx,bb_graphics_context.m_ty);
		this.m_matDirty=0;
	}
	return 0;
}
var bb_graphics_context=null;
function bb_data_FixDataPath(t_path){
	var t_i=t_path.indexOf(":/",0);
	if(t_i!=-1 && t_path.indexOf("/",0)==t_i+1){
		return t_path;
	}
	if(string_startswith(t_path,"./") || string_startswith(t_path,"/")){
		return t_path;
	}
	return "monkey://data/"+t_path;
}
function c_Frame(){
	Object.call(this);
	this.m_x=0;
	this.m_y=0;
}
c_Frame.m_new=function(t_x,t_y){
	this.m_x=t_x;
	this.m_y=t_y;
	return this;
}
c_Frame.m_new2=function(){
	return this;
}
function bb_graphics_LoadImage(t_path,t_frameCount,t_flags){
	var t_surf=bb_graphics_device.LoadSurface(bb_data_FixDataPath(t_path));
	if((t_surf)!=null){
		return (c_Image.m_new.call(new c_Image)).p_Init(t_surf,t_frameCount,t_flags);
	}
	return null;
}
function bb_graphics_LoadImage2(t_path,t_frameWidth,t_frameHeight,t_frameCount,t_flags){
	var t_atlas=bb_graphics_LoadImage(t_path,1,0);
	if((t_atlas)!=null){
		return t_atlas.p_GrabImage(0,0,t_frameWidth,t_frameHeight,t_frameCount,t_flags);
	}
	return null;
}
function bb_graphics_SetFont(t_font,t_firstChar){
	if(!((t_font)!=null)){
		if(!((bb_graphics_context.m_defaultFont)!=null)){
			bb_graphics_context.m_defaultFont=bb_graphics_LoadImage("mojo_font.png",96,2);
		}
		t_font=bb_graphics_context.m_defaultFont;
		t_firstChar=32;
	}
	bb_graphics_context.m_font=t_font;
	bb_graphics_context.m_firstChar=t_firstChar;
	return 0;
}
var bb_audio_device=null;
function bb_audio_SetAudioDevice(t_dev){
	bb_audio_device=t_dev;
	return 0;
}
function c_InputDevice(){
	Object.call(this);
	this.m__joyStates=new_object_array(4);
	this.m__keyDown=new_bool_array(512);
	this.m__keyHitPut=0;
	this.m__keyHitQueue=new_number_array(33);
	this.m__keyHit=new_number_array(512);
	this.m__charGet=0;
	this.m__charPut=0;
	this.m__charQueue=new_number_array(32);
	this.m__mouseX=.0;
	this.m__mouseY=.0;
	this.m__touchX=new_number_array(32);
	this.m__touchY=new_number_array(32);
	this.m__accelX=.0;
	this.m__accelY=.0;
	this.m__accelZ=.0;
}
c_InputDevice.m_new=function(){
	for(var t_i=0;t_i<4;t_i=t_i+1){
		this.m__joyStates[t_i]=c_JoyState.m_new.call(new c_JoyState);
	}
	return this;
}
c_InputDevice.prototype.p_PutKeyHit=function(t_key){
	if(this.m__keyHitPut==this.m__keyHitQueue.length){
		return;
	}
	this.m__keyHit[t_key]+=1;
	this.m__keyHitQueue[this.m__keyHitPut]=t_key;
	this.m__keyHitPut+=1;
}
c_InputDevice.prototype.p_BeginUpdate=function(){
	for(var t_i=0;t_i<4;t_i=t_i+1){
		var t_state=this.m__joyStates[t_i];
		if(!BBGame.Game().PollJoystick(t_i,t_state.m_joyx,t_state.m_joyy,t_state.m_joyz,t_state.m_buttons)){
			break;
		}
		for(var t_j=0;t_j<32;t_j=t_j+1){
			var t_key=256+t_i*32+t_j;
			if(t_state.m_buttons[t_j]){
				if(!this.m__keyDown[t_key]){
					this.m__keyDown[t_key]=true;
					this.p_PutKeyHit(t_key);
				}
			}else{
				this.m__keyDown[t_key]=false;
			}
		}
	}
}
c_InputDevice.prototype.p_EndUpdate=function(){
	for(var t_i=0;t_i<this.m__keyHitPut;t_i=t_i+1){
		this.m__keyHit[this.m__keyHitQueue[t_i]]=0;
	}
	this.m__keyHitPut=0;
	this.m__charGet=0;
	this.m__charPut=0;
}
c_InputDevice.prototype.p_KeyEvent=function(t_event,t_data){
	var t_1=t_event;
	if(t_1==1){
		if(!this.m__keyDown[t_data]){
			this.m__keyDown[t_data]=true;
			this.p_PutKeyHit(t_data);
			if(t_data==1){
				this.m__keyDown[384]=true;
				this.p_PutKeyHit(384);
			}else{
				if(t_data==384){
					this.m__keyDown[1]=true;
					this.p_PutKeyHit(1);
				}
			}
		}
	}else{
		if(t_1==2){
			if(this.m__keyDown[t_data]){
				this.m__keyDown[t_data]=false;
				if(t_data==1){
					this.m__keyDown[384]=false;
				}else{
					if(t_data==384){
						this.m__keyDown[1]=false;
					}
				}
			}
		}else{
			if(t_1==3){
				if(this.m__charPut<this.m__charQueue.length){
					this.m__charQueue[this.m__charPut]=t_data;
					this.m__charPut+=1;
				}
			}
		}
	}
}
c_InputDevice.prototype.p_MouseEvent=function(t_event,t_data,t_x,t_y){
	var t_2=t_event;
	if(t_2==4){
		this.p_KeyEvent(1,1+t_data);
	}else{
		if(t_2==5){
			this.p_KeyEvent(2,1+t_data);
			return;
		}else{
			if(t_2==6){
			}else{
				return;
			}
		}
	}
	this.m__mouseX=t_x;
	this.m__mouseY=t_y;
	this.m__touchX[0]=t_x;
	this.m__touchY[0]=t_y;
}
c_InputDevice.prototype.p_TouchEvent=function(t_event,t_data,t_x,t_y){
	var t_3=t_event;
	if(t_3==7){
		this.p_KeyEvent(1,384+t_data);
	}else{
		if(t_3==8){
			this.p_KeyEvent(2,384+t_data);
			return;
		}else{
			if(t_3==9){
			}else{
				return;
			}
		}
	}
	this.m__touchX[t_data]=t_x;
	this.m__touchY[t_data]=t_y;
	if(t_data==0){
		this.m__mouseX=t_x;
		this.m__mouseY=t_y;
	}
}
c_InputDevice.prototype.p_MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	var t_4=t_event;
	if(t_4==10){
	}else{
		return;
	}
	this.m__accelX=t_x;
	this.m__accelY=t_y;
	this.m__accelZ=t_z;
}
c_InputDevice.prototype.p_KeyDown=function(t_key){
	if(t_key>0 && t_key<512){
		return this.m__keyDown[t_key];
	}
	return false;
}
c_InputDevice.prototype.p_KeyHit=function(t_key){
	if(t_key>0 && t_key<512){
		return this.m__keyHit[t_key];
	}
	return 0;
}
function c_JoyState(){
	Object.call(this);
	this.m_joyx=new_number_array(2);
	this.m_joyy=new_number_array(2);
	this.m_joyz=new_number_array(2);
	this.m_buttons=new_bool_array(32);
}
c_JoyState.m_new=function(){
	return this;
}
var bb_input_device=null;
function bb_input_SetInputDevice(t_dev){
	bb_input_device=t_dev;
	return 0;
}
var bb_graphics_renderDevice=null;
function bb_graphics_SetMatrix(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	bb_graphics_context.m_ix=t_ix;
	bb_graphics_context.m_iy=t_iy;
	bb_graphics_context.m_jx=t_jx;
	bb_graphics_context.m_jy=t_jy;
	bb_graphics_context.m_tx=t_tx;
	bb_graphics_context.m_ty=t_ty;
	bb_graphics_context.m_tformed=((t_ix!=1.0 || t_iy!=0.0 || t_jx!=0.0 || t_jy!=1.0 || t_tx!=0.0 || t_ty!=0.0)?1:0);
	bb_graphics_context.m_matDirty=1;
	return 0;
}
function bb_graphics_SetMatrix2(t_m){
	bb_graphics_SetMatrix(t_m[0],t_m[1],t_m[2],t_m[3],t_m[4],t_m[5]);
	return 0;
}
function bb_graphics_SetColor(t_r,t_g,t_b){
	bb_graphics_context.m_color_r=t_r;
	bb_graphics_context.m_color_g=t_g;
	bb_graphics_context.m_color_b=t_b;
	bb_graphics_renderDevice.SetColor(t_r,t_g,t_b);
	return 0;
}
function bb_graphics_SetAlpha(t_alpha){
	bb_graphics_context.m_alpha=t_alpha;
	bb_graphics_renderDevice.SetAlpha(t_alpha);
	return 0;
}
function bb_graphics_SetBlend(t_blend){
	bb_graphics_context.m_blend=t_blend;
	bb_graphics_renderDevice.SetBlend(t_blend);
	return 0;
}
function bb_graphics_DeviceWidth(){
	return bb_graphics_device.Width();
}
function bb_graphics_DeviceHeight(){
	return bb_graphics_device.Height();
}
function bb_graphics_SetScissor(t_x,t_y,t_width,t_height){
	bb_graphics_context.m_scissor_x=t_x;
	bb_graphics_context.m_scissor_y=t_y;
	bb_graphics_context.m_scissor_width=t_width;
	bb_graphics_context.m_scissor_height=t_height;
	bb_graphics_renderDevice.SetScissor(((t_x)|0),((t_y)|0),((t_width)|0),((t_height)|0));
	return 0;
}
function bb_graphics_BeginRender(){
	bb_graphics_renderDevice=bb_graphics_device;
	bb_graphics_context.m_matrixSp=0;
	bb_graphics_SetMatrix(1.0,0.0,0.0,1.0,0.0,0.0);
	bb_graphics_SetColor(255.0,255.0,255.0);
	bb_graphics_SetAlpha(1.0);
	bb_graphics_SetBlend(0);
	bb_graphics_SetScissor(0.0,0.0,(bb_graphics_DeviceWidth()),(bb_graphics_DeviceHeight()));
	return 0;
}
function bb_graphics_EndRender(){
	bb_graphics_renderDevice=null;
	return 0;
}
function c_BBGameEvent(){
	Object.call(this);
}
function bb_app_EndApp(){
	error("");
	return 0;
}
function c_Display(){
	Object.call(this);
}
c_Display.m_w=0;
c_Display.m_h=0;
c_Display.m_hz=0;
c_Display.m_tFps=0;
c_Display.m_dw=0;
c_Display.m_dh=0;
c_Display.m_s=0;
c_Display.m_ox=0;
c_Display.m_oy=0;
c_Display.m_scissorX=0;
c_Display.m_scissorY=0;
c_Display.m_scissorW=0;
c_Display.m_scissorH=0;
c_Display.m_old_ms=0;
c_Display.m_ini_ms=0;
c_Display.m_d=0;
c_Display.m_fps=0;
c_Display.m_GetX=function(t_px){
	return ((((t_px)-c_Display.m_ox)/c_Display.m_s)|0);
}
c_Display.m_realXMin=0;
c_Display.m_GetY=function(t_py){
	return ((((t_py)-c_Display.m_oy)/c_Display.m_s)|0);
}
c_Display.m_realYMin=0;
c_Display.m_realXMax=0;
c_Display.m_realYMax=0;
c_Display.m_realW=0;
c_Display.m_realH=0;
c_Display.m_Init=function(t__w,t__h,t__hz,t_oXPos,t_oYPos,t_scissor){
	c_Display.m_w=t__w;
	c_Display.m_h=t__h;
	c_Display.m_hz=t__hz;
	c_Display.m_tFps=34.482758620689658;
	c_Display.m_dw=(bb_graphics_DeviceWidth());
	c_Display.m_dh=(bb_graphics_DeviceHeight());
	var t_sx=c_Display.m_dw/c_Display.m_w;
	var t_sy=c_Display.m_dh/c_Display.m_h;
	if(t_sx>t_sy){
		c_Display.m_s=t_sy;
	}else{
		c_Display.m_s=t_sx;
	}
	c_Display.m_ox=(c_Display.m_dw+c_Display.m_w*c_Display.m_s*(t_oXPos))/2.0;
	c_Display.m_oy=(c_Display.m_dh+c_Display.m_h*c_Display.m_s*(t_oYPos))/2.0;
	if(t_scissor){
		c_Display.m_scissorX=c_Display.m_ox;
		c_Display.m_scissorY=c_Display.m_oy;
		c_Display.m_scissorW=c_Display.m_dw-c_Display.m_ox*2.0;
		c_Display.m_scissorH=c_Display.m_dh-c_Display.m_oy*2.0;
	}else{
		c_Display.m_scissorX=0.0;
		c_Display.m_scissorY=0.0;
		c_Display.m_scissorW=c_Display.m_dw;
		c_Display.m_scissorH=c_Display.m_dh;
	}
	bb_app_SetUpdateRate((c_Display.m_hz)|0);
	c_Display.m_old_ms=bb_app_Millisecs();
	c_Display.m_ini_ms=c_Display.m_old_ms;
	c_Display.m_d=1.0;
	c_Display.m_fps=((c_Display.m_hz)|0);
	c_Display.m_realXMin=(c_Display.m_GetX(0));
	c_Display.m_realYMin=(c_Display.m_GetY(0));
	c_Display.m_realXMax=(c_Display.m_GetX((c_Display.m_dw-1.0)|0));
	c_Display.m_realYMax=(c_Display.m_GetY((c_Display.m_dh-1.0)|0));
	c_Display.m_realW=c_Display.m_realXMax+bb_math_Abs2(c_Display.m_realXMin)+1.0;
	c_Display.m_realH=c_Display.m_realYMax+bb_math_Abs2(c_Display.m_realYMin)+1.0;
	return 0;
}
c_Display.m_t=0;
c_Display.m_renders=0;
c_Display.m_milis=0;
c_Display.m_secs=0;
c_Display.m_Update=function(){
	c_Display.m_renders+=1;
	c_Display.m_milis=bb_app_Millisecs()-c_Display.m_ini_ms;
	if(bb_app_Millisecs()-c_Display.m_old_ms>=1000){
		c_Display.m_old_ms=bb_app_Millisecs();
		c_Display.m_fps=c_Display.m_renders;
		c_Display.m_renders=0;
		c_Display.m_d=c_Display.m_hz/(c_Display.m_fps);
		c_Display.m_secs+=1;
	}
	bb_graphics_Translate(c_Display.m_ox,c_Display.m_oy);
	bb_graphics_Scale(c_Display.m_s,c_Display.m_s);
	bb_graphics_SetScissor(c_Display.m_scissorX,c_Display.m_scissorY,c_Display.m_scissorW,c_Display.m_scissorH);
	c_Display.m_t=(((musicPlayer.getPosition())/c_Display.m_tFps)|0);
	return 0;
}
var bb_app__updateRate=0;
function bb_app_SetUpdateRate(t_hertz){
	bb_app__updateRate=t_hertz;
	bb_app__game.SetUpdateRate(t_hertz);
	return 0;
}
function bb_app_Millisecs(){
	return bb_app__game.Millisecs();
}
function bb_math_Abs(t_x){
	if(t_x>=0){
		return t_x;
	}
	return -t_x;
}
function bb_math_Abs2(t_x){
	if(t_x>=0.0){
		return t_x;
	}
	return -t_x;
}
var bb_random_Seed=0;
function c_Vec2(){
	Object.call(this);
	this.m_x=.0;
	this.m_y=.0;
}
c_Vec2.prototype.p_Set=function(t_x,t_y){
	this.m_x=t_x;
	this.m_y=t_y;
	return 0;
}
c_Vec2.prototype.p_Set2=function(t_v){
	this.m_x=t_v.m_x;
	this.m_y=t_v.m_y;
	return 0;
}
c_Vec2.m_new=function(t_x,t_y){
	this.p_Set(t_x,t_y);
	return this;
}
c_Vec2.m_new2=function(t_v){
	this.p_Set2(t_v);
	return this;
}
c_Vec2.prototype.p_Add=function(t_x,t_y){
	this.m_x+=t_x;
	this.m_y+=t_y;
	return 0;
}
c_Vec2.prototype.p_Add2=function(t_v){
	this.m_x+=t_v.m_x;
	this.m_y+=t_v.m_y;
	return 0;
}
function c_Camera3D(){
	Object.call(this);
}
c_Camera3D.m_origin=null;
c_Camera3D.m_dist=0;
c_Camera3D.m_near=0;
c_Camera3D.m_far=0;
c_Camera3D.m_focusDist=0;
c_Camera3D.m_focusLength=[];
c_Camera3D.m_SetFocus=function(t_dist,t_length){
	c_Camera3D.m_focusDist=t_dist;
	c_Camera3D.m_focusLength[0]=t_length;
	c_Camera3D.m_focusLength[1]=t_length+t_length*0.5;
	c_Camera3D.m_focusLength[2]=t_length+t_length*0.5+t_length*0.25;
	return 0;
}
c_Camera3D.m_Init=function(t__origin,t__dist){
	c_Camera3D.m_origin=c_Vec2.m_new2.call(new c_Vec2,t__origin);
	c_Camera3D.m_dist=t__dist;
	c_Camera3D.m_near=1.0;
	c_Camera3D.m_far=1000.0;
	c_Camera3D.m_SetFocus(c_Camera3D.m_far/2.0,50.0);
	return 0;
}
c_Camera3D.m_GetFocalSize=function(t_z){
	return c_Camera3D.m_dist/t_z;
}
c_Camera3D.m_InView=function(t_z){
	if(t_z>=c_Camera3D.m_near && t_z<=c_Camera3D.m_far){
		return true;
	}else{
		return false;
	}
}
c_Camera3D.m_GetFocus=function(t_z){
	var t_d=bb_math_Abs2(c_Camera3D.m_focusDist-t_z);
	if(t_d>c_Camera3D.m_focusLength[2]){
		return 3;
	}else{
		if(t_d>c_Camera3D.m_focusLength[1]){
			return 2;
		}else{
			if(t_d>c_Camera3D.m_focusLength[0]){
				return 1;
			}else{
				return 0;
			}
		}
	}
}
function c_Assets(){
	Object.call(this);
}
c_Assets.m_img_fire=[];
c_Assets.m_img_chispa=null;
c_Assets.m_img_nube=[];
c_Assets.m_img_bgnubes=null;
c_Assets.m_img_bgfuego=null;
c_Assets.m_img_burbuja=null;
c_Assets.m_img_bgburbuja=null;
c_Assets.m_img_bolahierro=null;
c_Assets.m_img_bolafire=null;
c_Assets.m_img_frame=[];
c_Assets.m_img_parallax=[];
c_Assets.m_img_bolaacero=[];
c_Assets.m_img_bgbolaacero=null;
c_Assets.m_txt_icevan=null;
c_Assets.m_txt_kba=null;
c_Assets.m_txt_illl=null;
c_Assets.m_txt_titulo=null;
c_Assets.m_txt_purple=null;
c_Assets.m_txt_mouse=null;
c_Assets.m_txt_euskal=null;
c_Assets.m_img_flare=null;
c_Assets.m_Load=function(){
	for(var t_n=0;t_n<c_Assets.m_img_fire.length;t_n=t_n+1){
		c_Assets.m_img_fire[t_n]=bb_graphics_LoadImage("fire"+String(t_n)+".png",1,c_Image.m_DefaultFlags);
	}
	c_Assets.m_img_chispa=bb_graphics_LoadImage("chispa.png",1,c_Image.m_DefaultFlags);
	for(var t_n2=0;t_n2<c_Assets.m_img_nube.length;t_n2=t_n2+1){
		c_Assets.m_img_nube[t_n2]=bb_graphics_LoadImage("nube"+String(t_n2)+".png",1,c_Image.m_DefaultFlags);
	}
	c_Assets.m_img_bgnubes=bb_graphics_LoadImage("bgnubes.jpg",1,c_Image.m_DefaultFlags);
	c_Assets.m_img_bgfuego=bb_graphics_LoadImage("bgfuego.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_img_burbuja=bb_graphics_LoadImage("burbuja.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_img_bgburbuja=bb_graphics_LoadImage2("bgburbuja.jpg",768,4,120,c_Image.m_DefaultFlags);
	c_Assets.m_img_bolahierro=bb_graphics_LoadImage("bolahierro.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_img_bolafire=bb_graphics_LoadImage("bolafire.png",1,c_Image.m_DefaultFlags);
	for(var t_n3=0;t_n3<c_Assets.m_img_frame.length;t_n3=t_n3+1){
		c_Assets.m_img_frame[t_n3]=bb_graphics_LoadImage("frame"+String(t_n3)+".png",1,c_Image.m_DefaultFlags);
	}
	for(var t_n4=0;t_n4<c_Assets.m_img_parallax.length;t_n4=t_n4+1){
		c_Assets.m_img_parallax[t_n4]=bb_graphics_LoadImage("parallax"+String(t_n4)+".png",1,c_Image.m_DefaultFlags);
	}
	for(var t_n5=0;t_n5<c_Assets.m_img_bolaacero.length;t_n5=t_n5+1){
		c_Assets.m_img_bolaacero[t_n5]=bb_graphics_LoadImage("bolaacero"+String(t_n5)+".png",1,c_Image.m_DefaultFlags);
	}
	c_Assets.m_img_bgbolaacero=bb_graphics_LoadImage("bgbolaacero.jpg",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_icevan=bb_graphics_LoadImage("txt_icevan.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_kba=bb_graphics_LoadImage("txt_kba.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_illl=bb_graphics_LoadImage("txt_illl.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_titulo=bb_graphics_LoadImage("txt_titulo.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_purple=bb_graphics_LoadImage("txt_purple.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_mouse=bb_graphics_LoadImage("txt_mouse.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_txt_euskal=bb_graphics_LoadImage("txt_euskal.png",1,c_Image.m_DefaultFlags);
	c_Assets.m_img_flare=bb_graphics_LoadImage("flare.png",1,c_Image.m_DefaultFlags);
	return 0;
}
c_Assets.m_data_64f=[];
c_Assets.m_obj_fireball="";
c_Assets.m_data_128=[];
c_Assets.m_data_8=[];
c_Assets.m_data_512=[];
c_Assets.m_obj_toro="";
function c_Fade(){
	Object.call(this);
	this.m_img=null;
	this.m_state="";
	this.m_vel=.0;
	this.m_alfa=.0;
}
c_Fade.m_new=function(){
	this.m_img=bb_graphics_LoadImage("fade.png",1,c_Image.m_DefaultFlags);
	return this;
}
c_Fade.prototype.p_Update=function(){
	var t_1=this.m_state;
	if(t_1=="in"){
		this.m_alfa-=this.m_vel;
		if(this.m_alfa<0.0){
			this.m_alfa=0.0;
		}
	}else{
		if(t_1=="out"){
			this.m_alfa+=this.m_vel;
			if(this.m_alfa>1.0){
				this.m_alfa=1.0;
			}
		}
	}
	return 0;
}
c_Fade.prototype.p_Set3=function(t_vel,t_state){
	this.m_vel=t_vel;
	if(t_state=="in"){
		this.m_alfa=1.0;
	}else{
		this.m_alfa=0.0;
	}
	this.m_state=t_state;
	return 0;
}
c_Fade.prototype.p_Draw=function(){
	bb_graphics_PushMatrix();
	bb_graphics_Scale(10.0,10.0);
	bb_graphics_SetAlpha(this.m_alfa);
	bb_graphics_DrawImage(this.m_img,0.0,0.0,0);
	bb_graphics_PopMatrix();
	bb_graphics_SetAlpha(1.0);
	return 0;
}
function bb_input_KeyDown(t_key){
	return ((bb_input_device.p_KeyDown(t_key))?1:0);
}
function bb_input_MouseHit(t_button){
	return bb_input_device.p_KeyHit(1+t_button);
}
function bb_audio_PlayMusic(t_path,t_flags){
	return bb_audio_device.PlayMusic(bb_data_FixDataPath(t_path),t_flags);
}
function c_StarField(){
	Object.call(this);
	this.m_obj=null;
	this.m_vel=[];
}
c_StarField.m__RAD=0;
c_StarField.m__DEPTH=0;
c_StarField.prototype.p_ResetStar=function(t_o){
	var t_ang=bb_random_Rnd2(0.0,360.0);
	var t_rad=bb_random_Rnd2(1.0,(c_StarField.m__RAD));
	var t_scale=bb_random_Rnd2(0.001,0.005)*16.0;
	t_o.m_pos.m_x=Math.cos((t_ang)*D2R)*t_rad;
	t_o.m_pos.m_y=Math.sin((t_ang)*D2R)*t_rad;
	t_o.m_pos.m_z=(c_StarField.m__DEPTH);
	t_o.m_scale.p_Set(t_scale,t_scale);
	return 0;
}
c_StarField.m_new=function(t_img,t_data,t_sprScale,t_num){
	this.m_obj=c_Object3D.m_new.call(new c_Object3D,true,false,true);
	this.m_obj.m_pos.p_Set4(0.0,0.0,(c_StarField.m__RAD));
	this.m_vel=new_number_array(t_num);
	for(var t_n=0;t_n<t_num;t_n=t_n+1){
		this.m_vel[t_n]=bb_random_Rnd2(0.25,3.0)*0.25;
		var t_star=this.m_obj.p_InsertSprite(c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0),t_img[((bb_random_Rnd2(0.0,(t_img.length)))|0)],t_data,t_sprScale);
		this.p_ResetStar(t_star);
		t_star.m_pos.m_z=bb_random_Rnd2((-c_StarField.m__DEPTH),(c_StarField.m__DEPTH));
	}
	return this;
}
c_StarField.m_new2=function(){
	return this;
}
c_StarField.prototype.p_Update=function(){
	this.m_obj.m_ang.p_Add3(0.125*c_Display.m_d,0.05*c_Display.m_d,0.5*c_Display.m_d);
	var t_cont=0;
	var t_=this.m_obj.m_sprite3DList.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.m_pos.m_z-=this.m_vel[t_cont]*c_Display.m_d;
		if(t_o.m_pos.m_z<=(-c_StarField.m__DEPTH)){
			this.p_ResetStar(t_o);
		}
		t_o.m_a=1.0-bb_math_Abs2(t_o.m_pos.m_z)/(c_StarField.m__DEPTH);
		t_cont+=1;
	}
	return 0;
}
function c_Object3D(){
	Object.call(this);
	this.m_pos=null;
	this.m_ang=null;
	this.m_size=null;
	this.m_perspective=false;
	this.m_depth=false;
	this.m_visible=false;
	this.m_sprite3DList=c_Sprite3DList.m_new.call(new c_Sprite3DList);
}
c_Object3D.m_list=null;
c_Object3D.prototype.p_Init2=function(t__perspective,t__depth,t__visible){
	this.m_pos=c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0);
	this.m_ang=c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0);
	this.m_size=c_Vec3.m_new.call(new c_Vec3,1.0,1.0,1.0);
	this.m_perspective=t__perspective;
	this.m_depth=t__depth;
	this.m_visible=t__visible;
	c_Object3D.m_list.p_AddLast(this);
	return 0;
}
c_Object3D.m_new=function(t__perspective,t__depth,t__visible){
	this.p_Init2(t__perspective,t__depth,t__visible);
	return this;
}
c_Object3D.prototype.p_InsertSprite=function(t_pos,t_img,t_data,t_sprScale){
	var t_spr=c_Sprite3D.m_new.call(new c_Sprite3D,t_img,t_data,this.m_perspective,this.m_depth,this.m_visible);
	t_spr.m_pos.p_Set5(t_pos);
	t_spr.m_scale.p_Set(t_sprScale,t_sprScale);
	this.m_sprite3DList.p_AddLast2(t_spr);
	return t_spr;
}
c_Object3D.prototype.p_LoadObj=function(t_fileData,t_img,t_data,t_sprScale,t_obj){
	var t_v=[];
	if(t_obj==false){
		t_v=t_fileData.split("/");
	}else{
		t_v=t_fileData.split(String.fromCharCode(10));
	}
	var t_objtxt="";
	var t_cont=0;
	for(var t_n=0;t_n<t_v.length-1;t_n=t_n+1){
		if((t_v[t_n].indexOf("v ")!=-1)==true){
			var t_p=t_v[t_n].split(" ");
			var t_x=parseFloat(t_p[1]);
			var t_y=parseFloat(t_p[2]);
			var t_z=parseFloat(t_p[3]);
			if(t_obj){
				t_objtxt=t_objtxt+"v "+String(t_x)+" "+String(t_y)+" "+String(t_z)+"/";
			}
			this.p_InsertSprite(c_Vec3.m_new.call(new c_Vec3,parseFloat(t_p[1]),parseFloat(t_p[2]),parseFloat(t_p[3])),t_img,t_data,t_sprScale);
		}
	}
	print(t_objtxt);
	return 0;
}
c_Object3D.m_new2=function(t_file,t_img,t_data,t_sprScale,t__perspective,t__depth,t__visible){
	this.p_Init2(t__perspective,t__depth,t__visible);
	if(t_file.indexOf(".obj")!=-1){
		this.p_LoadObj(bb_app_LoadString(t_file),t_img,t_data,t_sprScale,true);
	}else{
		this.p_LoadObj(t_file,t_img,t_data,t_sprScale,false);
	}
	return this;
}
c_Object3D.prototype.p_Update=function(){
	var t_=this.m_sprite3DList.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.p_Scalation(this.m_size);
		t_o.p_Rotation(this.m_ang);
		t_o.p_Translation(this.m_pos);
		t_o.p_Proyection();
	}
	return 0;
}
c_Object3D.m_UpdateAll=function(){
	var t_=c_Object3D.m_list.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.p_Update();
	}
	return 0;
}
function c_Vec3(){
	Object.call(this);
	this.m_x=.0;
	this.m_y=.0;
	this.m_z=.0;
}
c_Vec3.prototype.p_Set4=function(t_x,t_y,t_z){
	this.m_x=t_x;
	this.m_y=t_y;
	this.m_z=t_z;
	return 0;
}
c_Vec3.prototype.p_Set5=function(t_v){
	this.m_x=t_v.m_x;
	this.m_y=t_v.m_y;
	this.m_z=t_v.m_z;
	return 0;
}
c_Vec3.m_new=function(t_x,t_y,t_z){
	this.p_Set4(t_x,t_y,t_z);
	return this;
}
c_Vec3.m_new2=function(t_v){
	this.p_Set5(t_v);
	return this;
}
c_Vec3.prototype.p_Add3=function(t_x,t_y,t_z){
	this.m_x+=t_x;
	this.m_y+=t_y;
	this.m_z+=t_z;
	return 0;
}
c_Vec3.prototype.p_Add4=function(t_v){
	this.m_x+=t_v.m_x;
	this.m_y+=t_v.m_y;
	this.m_z+=t_v.m_z;
	return 0;
}
c_Vec3.prototype.p_Mul=function(t_x,t_y,t_z){
	this.m_x*=t_x;
	this.m_y*=t_y;
	this.m_z*=t_z;
	return 0;
}
c_Vec3.prototype.p_Mul2=function(t_v){
	this.m_x*=t_v.m_x;
	this.m_y*=t_v.m_y;
	this.m_z*=t_v.m_z;
	return 0;
}
function c_List(){
	Object.call(this);
	this.m__head=(c_HeadNode.m_new.call(new c_HeadNode));
}
c_List.m_new=function(){
	return this;
}
c_List.prototype.p_AddLast=function(t_data){
	return c_Node.m_new.call(new c_Node,this.m__head,this.m__head.m__pred,t_data);
}
c_List.m_new2=function(t_data){
	var t_=t_data;
	var t_2=0;
	while(t_2<t_.length){
		var t_t=t_[t_2];
		t_2=t_2+1;
		this.p_AddLast(t_t);
	}
	return this;
}
c_List.prototype.p_ObjectEnumerator=function(){
	return c_Enumerator4.m_new.call(new c_Enumerator4,this);
}
function c_Node(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node.m_new=function(t_succ,t_pred,t_data){
	this.m__succ=t_succ;
	this.m__pred=t_pred;
	this.m__succ.m__pred=this;
	this.m__pred.m__succ=this;
	this.m__data=t_data;
	return this;
}
c_Node.m_new2=function(){
	return this;
}
function c_HeadNode(){
	c_Node.call(this);
}
c_HeadNode.prototype=extend_class(c_Node);
c_HeadNode.m_new=function(){
	c_Node.m_new2.call(this);
	this.m__succ=(this);
	this.m__pred=(this);
	return this;
}
function bb_app_LoadString(t_path){
	return bb_app__game.LoadString(bb_data_FixDataPath(t_path));
}
function c_Sprite3D(){
	Object.call(this);
	this.m_data=[];
	this.m_img=null;
	this.m_scale=null;
	this.m_pos=null;
	this.m_posW=null;
	this.m_angW=null;
	this.m_screenPos=null;
	this.m_pivot=null;
	this.m_frames=0;
	this.m_perspective=true;
	this.m_depth=false;
	this.m_visible=true;
	this.m_a=1.0;
	this.m_blend=0;
	this.m_ang=.0;
	this.m_focalSize=.0;
	this.m_r=255;
	this.m_g=255;
	this.m_b=255;
	this.m_frame=0.0;
	this.m_single=false;
}
c_Sprite3D.m_list=null;
c_Sprite3D.prototype.p_Init3=function(t_img,t_data,t__perspective,t__depth,t__visible){
	this.m_data=t_data;
	this.m_img=t_img;
	this.m_scale=c_Vec2.m_new.call(new c_Vec2,1.0,1.0);
	this.m_pos=c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0);
	this.m_posW=c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0);
	this.m_angW=c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0);
	this.m_screenPos=c_Vec2.m_new.call(new c_Vec2,0.0,0.0);
	this.m_pivot=c_Vec2.m_new.call(new c_Vec2,(this.m_data[0][7])/2.0,(this.m_data[0][8])/2.0);
	this.m_frames=t_data.length;
	this.m_perspective=t__perspective;
	this.m_depth=t__depth;
	this.m_visible=t__visible;
	c_Sprite3D.m_list.p_AddLast2(this);
	return 0;
}
c_Sprite3D.m_new=function(t_img,t_data,t__perspective,t__depth,t__visible){
	this.p_Init3(t_img,t_data,t__perspective,t__depth,t__visible);
	return this;
}
c_Sprite3D.m_new2=function(t_img,t__perspective,t__depth,t__visible){
	this.p_Init3(t_img,[[0,0,0,t_img.p_Width(),t_img.p_Height(),0,0,t_img.p_Width(),t_img.p_Height()]],t__perspective,t__depth,t__visible);
	return this;
}
c_Sprite3D.m_new3=function(){
	return this;
}
c_Sprite3D.m_DestroyAll=function(){
	c_Sprite3D.m_list.p_Clear();
	return 0;
}
c_Sprite3D.prototype.p_Scalation=function(t__scale){
	this.m_posW.p_Set5(this.m_pos);
	this.m_posW.p_Mul2(t__scale);
	return 0;
}
c_Sprite3D.prototype.p_Rotation=function(t__ang){
	var t_posT=c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0);
	var t_cosx=Math.cos((t__ang.m_y)*D2R);
	var t_cosy=Math.cos((t__ang.m_z)*D2R);
	var t_cosz=Math.cos((t__ang.m_x)*D2R);
	var t_sinx=Math.sin((t__ang.m_y)*D2R);
	var t_siny=Math.sin((t__ang.m_z)*D2R);
	var t_sinz=Math.sin((t__ang.m_x)*D2R);
	t_posT.m_x=t_cosx*this.m_posW.m_x-t_sinx*this.m_posW.m_z;
	t_posT.m_z=t_sinx*this.m_posW.m_x+t_cosx*this.m_posW.m_z;
	this.m_posW.m_x=t_cosy*t_posT.m_x-t_siny*this.m_posW.m_y;
	t_posT.m_y=t_cosy*this.m_posW.m_y+t_siny*t_posT.m_x;
	this.m_posW.m_z=t_cosz*t_posT.m_z-t_sinz*t_posT.m_y;
	this.m_posW.m_y=t_sinz*t_posT.m_z+t_cosz*t_posT.m_y;
	return 0;
}
c_Sprite3D.prototype.p_Translation=function(t__pos){
	this.m_posW.p_Add3(t__pos.m_x,-t__pos.m_y,t__pos.m_z);
	return 0;
}
c_Sprite3D.prototype.p_Proyection=function(){
	this.m_screenPos.p_Set(c_Camera3D.m_dist*this.m_posW.m_x/this.m_posW.m_z+c_Camera3D.m_origin.m_x,c_Camera3D.m_dist*this.m_posW.m_y/this.m_posW.m_z+c_Camera3D.m_origin.m_y);
	if(this.m_perspective){
		this.m_focalSize=c_Camera3D.m_GetFocalSize(this.m_posW.m_z);
	}else{
		this.m_focalSize=1.0;
	}
	return 0;
}
c_Sprite3D.prototype.p_Destroy=function(){
	c_Sprite3D.m_list.p_RemoveEach(this);
	return 0;
}
c_Sprite3D.prototype.p_DrawSingle=function(){
	bb_graphics_PushMatrix();
	bb_graphics_Translate(this.m_screenPos.m_x,this.m_screenPos.m_y);
	bb_graphics_Rotate(this.m_ang);
	bb_graphics_Scale(this.m_scale.m_x*this.m_focalSize,this.m_scale.m_y*this.m_focalSize);
	bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
	bb_graphics_DrawImage(this.m_img,0.0,0.0,0);
	bb_graphics_PopMatrix();
	return 0;
}
c_Sprite3D.prototype.p_DrawComplex=function(){
	bb_graphics_PushMatrix();
	var t_f=((this.m_frame)|0);
	var t_1=this.m_data[t_f][0];
	if(t_1==-1){
		bb_graphics_Translate(this.m_screenPos.m_x+(this.m_data[t_f][5])+(this.m_data[t_f][3]),this.m_screenPos.m_y+(this.m_data[t_f][6]));
		bb_graphics_Rotate(this.m_ang-90.0);
		bb_graphics_Scale(this.m_scale.m_x*this.m_focalSize,this.m_scale.m_y*this.m_focalSize);
		bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
		bb_graphics_DrawImageRect(this.m_img,0.0,0.0,this.m_data[t_f][1],this.m_data[t_f][2],this.m_data[t_f][4],this.m_data[t_f][3],0);
	}else{
		if(t_1==0){
			bb_graphics_Translate(this.m_screenPos.m_x+(this.m_data[t_f][5]),this.m_screenPos.m_y+(this.m_data[t_f][6]));
			bb_graphics_Rotate(this.m_ang);
			bb_graphics_Scale(this.m_scale.m_x*this.m_focalSize,this.m_scale.m_y*this.m_focalSize);
			bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
			bb_graphics_DrawImageRect(this.m_img,0.0,0.0,this.m_data[t_f][1],this.m_data[t_f][2],this.m_data[t_f][3],this.m_data[t_f][4],0);
		}else{
			if(t_1==1){
				bb_graphics_Translate(this.m_screenPos.m_x+(this.m_data[t_f][5])+(this.m_data[t_f][4]),this.m_screenPos.m_y+(this.m_data[t_f][6]));
				bb_graphics_Rotate(this.m_ang-90.0);
				bb_graphics_Scale(this.m_scale.m_x*this.m_focalSize,this.m_scale.m_y*this.m_focalSize);
				bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
				bb_graphics_DrawImageRect(this.m_img,0.0,0.0,this.m_data[t_f][1],this.m_data[t_f][2],this.m_data[t_f][3],this.m_data[t_f][4],0);
			}
		}
	}
	bb_graphics_PopMatrix();
	return 0;
}
c_Sprite3D.prototype.p_Draw=function(){
	bb_graphics_SetColor((this.m_r),(this.m_g),(this.m_b));
	bb_graphics_SetAlpha(this.m_a);
	bb_graphics_SetBlend(this.m_blend);
	if(this.m_depth){
		this.m_frame=(c_Camera3D.m_GetFocus(this.m_posW.m_z));
	}
	if(this.m_single){
		this.p_DrawSingle();
	}else{
		this.p_DrawComplex();
	}
	return 0;
}
c_Sprite3D.m_RenderAll=function(){
	c_Sprite3D.m_list.p_Sort(0);
	var t_=c_Sprite3D.m_list.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		if(c_Camera3D.m_InView(t_o.m_posW.m_z) && t_o.m_visible){
			t_o.p_Draw();
		}
	}
	bb_graphics_SetAlpha(1.0);
	bb_graphics_SetBlend(0);
	return 0;
}
function c_List2(){
	Object.call(this);
	this.m__head=(c_HeadNode2.m_new.call(new c_HeadNode2));
}
c_List2.m_new=function(){
	return this;
}
c_List2.prototype.p_AddLast2=function(t_data){
	return c_Node2.m_new.call(new c_Node2,this.m__head,this.m__head.m__pred,t_data);
}
c_List2.m_new2=function(t_data){
	var t_=t_data;
	var t_2=0;
	while(t_2<t_.length){
		var t_t=t_[t_2];
		t_2=t_2+1;
		this.p_AddLast2(t_t);
	}
	return this;
}
c_List2.prototype.p_ObjectEnumerator=function(){
	return c_Enumerator.m_new.call(new c_Enumerator,this);
}
c_List2.prototype.p_Clear=function(){
	this.m__head.m__succ=this.m__head;
	this.m__head.m__pred=this.m__head;
	return 0;
}
c_List2.prototype.p_Equals=function(t_lhs,t_rhs){
	return t_lhs==t_rhs;
}
c_List2.prototype.p_RemoveEach=function(t_value){
	var t_node=this.m__head.m__succ;
	while(t_node!=this.m__head){
		var t_succ=t_node.m__succ;
		if(this.p_Equals(t_node.m__data,t_value)){
			t_node.p_Remove();
		}
		t_node=t_succ;
	}
	return 0;
}
c_List2.prototype.p_Compare=function(t_lhs,t_rhs){
	error("Unable to compare items");
	return 0;
}
c_List2.prototype.p_Sort=function(t_ascending){
	var t_ccsgn=-1;
	if((t_ascending)!=0){
		t_ccsgn=1;
	}
	var t_insize=1;
	do{
		var t_merges=0;
		var t_tail=this.m__head;
		var t_p=this.m__head.m__succ;
		while(t_p!=this.m__head){
			t_merges+=1;
			var t_q=t_p.m__succ;
			var t_qsize=t_insize;
			var t_psize=1;
			while(t_psize<t_insize && t_q!=this.m__head){
				t_psize+=1;
				t_q=t_q.m__succ;
			}
			do{
				var t_t=null;
				if(((t_psize)!=0) && ((t_qsize)!=0) && t_q!=this.m__head){
					var t_cc=this.p_Compare(t_p.m__data,t_q.m__data)*t_ccsgn;
					if(t_cc<=0){
						t_t=t_p;
						t_p=t_p.m__succ;
						t_psize-=1;
					}else{
						t_t=t_q;
						t_q=t_q.m__succ;
						t_qsize-=1;
					}
				}else{
					if((t_psize)!=0){
						t_t=t_p;
						t_p=t_p.m__succ;
						t_psize-=1;
					}else{
						if(((t_qsize)!=0) && t_q!=this.m__head){
							t_t=t_q;
							t_q=t_q.m__succ;
							t_qsize-=1;
						}else{
							break;
						}
					}
				}
				t_t.m__pred=t_tail;
				t_tail.m__succ=t_t;
				t_tail=t_t;
			}while(!(false));
			t_p=t_q;
		}
		t_tail.m__succ=this.m__head;
		this.m__head.m__pred=t_tail;
		if(t_merges<=1){
			return 0;
		}
		t_insize*=2;
	}while(!(false));
}
function c_Sprite3DList(){
	c_List2.call(this);
}
c_Sprite3DList.prototype=extend_class(c_List2);
c_Sprite3DList.m_new=function(){
	c_List2.m_new.call(this);
	return this;
}
c_Sprite3DList.prototype.p_Compare=function(t_a,t_b){
	if(t_a.m_posW.m_z>t_b.m_posW.m_z){
		return 1;
	}
	if(t_a.m_posW.m_z==t_b.m_posW.m_z){
		return 0;
	}
	return -1;
}
function c_Node2(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node2.m_new=function(t_succ,t_pred,t_data){
	this.m__succ=t_succ;
	this.m__pred=t_pred;
	this.m__succ.m__pred=this;
	this.m__pred.m__succ=this;
	this.m__data=t_data;
	return this;
}
c_Node2.m_new2=function(){
	return this;
}
c_Node2.prototype.p_Remove=function(){
	this.m__succ.m__pred=this.m__pred;
	this.m__pred.m__succ=this.m__succ;
	return 0;
}
function c_HeadNode2(){
	c_Node2.call(this);
}
c_HeadNode2.prototype=extend_class(c_Node2);
c_HeadNode2.m_new=function(){
	c_Node2.m_new2.call(this);
	this.m__succ=(this);
	this.m__pred=(this);
	return this;
}
function bb_random_Rnd(){
	bb_random_Seed=bb_random_Seed*1664525+1013904223|0;
	return (bb_random_Seed>>8&16777215)/16777216.0;
}
function bb_random_Rnd2(t_low,t_high){
	return bb_random_Rnd3(t_high-t_low)+t_low;
}
function bb_random_Rnd3(t_range){
	return bb_random_Rnd()*t_range;
}
function c_Calima(){
	Object.call(this);
	this.m_img=null;
	this.m_filas=0;
	this.m_angx=.0;
}
c_Calima.m_new=function(t_img,t_filas){
	this.m_img=t_img;
	this.m_filas=t_filas;
	return this;
}
c_Calima.m_new2=function(){
	return this;
}
c_Calima.prototype.p_Update=function(){
	for(var t_n=0;t_n<30;t_n=t_n+1){
	}
	return 0;
}
c_Calima.prototype.p_Draw=function(){
	bb_graphics_SetAlpha(1.0);
	this.m_angx+=0.5;
	var t_ang=0.0;
	for(var t_n=0;t_n<this.m_filas;t_n=t_n+1){
		t_ang=t_ang+5.0;
		bb_graphics_DrawImage(this.m_img,320.0+Math.cos((t_ang+this.m_angx)*D2R)*16.0-384.0,(t_n*4),t_n);
	}
	bb_graphics_SetAlpha(1.0);
	return 0;
}
function bb_input_KeyHit(t_key){
	return bb_input_device.p_KeyHit(t_key);
}
function c_Enumerator(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator.m_new=function(t_list){
	this.m__list=t_list;
	this.m__curr=t_list.m__head.m__succ;
	return this;
}
c_Enumerator.m_new2=function(){
	return this;
}
c_Enumerator.prototype.p_HasNext=function(){
	while(this.m__curr.m__succ.m__pred!=this.m__curr){
		this.m__curr=this.m__curr.m__succ;
	}
	return this.m__curr!=this.m__list.m__head;
}
c_Enumerator.prototype.p_NextObject=function(){
	var t_data=this.m__curr.m__data;
	this.m__curr=this.m__curr.m__succ;
	return t_data;
}
function c_FireObject(){
	Object.call(this);
	this.m_img=[];
	this.m_data=[];
	this.m_imgc=null;
	this.m_datac=[];
	this.m_obj=null;
	this.m_ang=90.0;
}
c_FireObject.m_new=function(t_file,t_imgo,t_datao,t_img,t_data,t_imgc,t_datac){
	this.m_img=t_img;
	this.m_data=t_data;
	this.m_imgc=t_imgc;
	this.m_datac=t_datac;
	this.m_obj=c_Object3D.m_new2.call(new c_Object3D,t_file,t_imgo,t_datao,0.04,true,true,true);
	this.m_obj.m_pos.p_Set4(0.0,0.0,30.0);
	return this;
}
c_FireObject.m_new2=function(){
	return this;
}
c_FireObject.prototype.p_Update=function(){
	this.m_obj.m_ang.p_Add3(1.0*c_Display.m_d,-0.5*c_Display.m_d,0.25*c_Display.m_d);
	this.m_ang-=0.2*c_Display.m_d;
	this.m_obj.m_pos.p_Set4(Math.cos((this.m_ang)*D2R)*8.0,Math.sin((this.m_ang*2.0)*D2R)*7.0,30.0+Math.sin((this.m_ang)*D2R)*20.0);
	var t_=this.m_obj.m_sprite3DList.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_s=t_.p_NextObject();
		if(((bb_random_Rnd2(0.0,100.0))|0)<10){
			if(((bb_random_Rnd2(0.0,100.0)<25.0)?1:0)!=0){
				c_Chispa.m_new.call(new c_Chispa,this.m_imgc,this.m_datac,t_s.m_posW);
			}else{
				c_Llama.m_new.call(new c_Llama,this.m_img[((bb_random_Rnd2(0.0,(this.m_img.length-1)))|0)],this.m_data,t_s.m_posW);
			}
		}
	}
	c_Llama.m_UpdateAll();
	c_Chispa.m_UpdateAll();
	return 0;
}
function c_Chispa(){
	Object.call(this);
	this.m_spr=null;
	this.m_x=.0;
	this.m_vel=.0;
	this.m_vida=.0;
	this.m_ang=.0;
}
c_Chispa.m_list=null;
c_Chispa.m_new=function(t_img,t_data,t__pos){
	this.m_spr=c_Sprite3D.m_new.call(new c_Sprite3D,t_img,t_data,true,false,true);
	this.m_spr.m_pos.p_Set5(t__pos);
	var t_s=bb_random_Rnd2(0.01,0.04);
	this.m_spr.m_scale.p_Set(t_s,t_s);
	this.m_spr.m_blend=1;
	this.m_x=t__pos.m_x;
	this.m_vel=-bb_random_Rnd2(0.1,0.3)/2.0;
	this.m_vida=bb_random_Rnd2(30.0,90.0);
	c_Chispa.m_list.p_AddLast3(this);
	return this;
}
c_Chispa.m_new2=function(){
	return this;
}
c_Chispa.prototype.p_Update=function(){
	this.m_spr.p_Scalation(c_Vec3.m_new.call(new c_Vec3,1.0,1.0,1.0));
	this.m_spr.p_Rotation(c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0));
	this.m_spr.p_Translation(c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0));
	this.m_spr.p_Proyection();
	this.m_spr.m_pos.m_y+=this.m_vel*c_Display.m_d;
	this.m_spr.m_pos.m_x=this.m_x+Math.cos((this.m_ang)*D2R)*0.25;
	this.m_ang+=10.0*c_Display.m_d;
	this.m_vida=this.m_vida-1.0;
	if(this.m_vida<=0.0){
		this.m_spr.p_Destroy();
		c_Chispa.m_list.p_RemoveEach2(this);
	}
	return 0;
}
c_Chispa.m_UpdateAll=function(){
	var t_=c_Chispa.m_list.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.p_Update();
	}
	return 0;
}
function c_List3(){
	Object.call(this);
	this.m__head=(c_HeadNode3.m_new.call(new c_HeadNode3));
}
c_List3.m_new=function(){
	return this;
}
c_List3.prototype.p_AddLast3=function(t_data){
	return c_Node3.m_new.call(new c_Node3,this.m__head,this.m__head.m__pred,t_data);
}
c_List3.m_new2=function(t_data){
	var t_=t_data;
	var t_2=0;
	while(t_2<t_.length){
		var t_t=t_[t_2];
		t_2=t_2+1;
		this.p_AddLast3(t_t);
	}
	return this;
}
c_List3.prototype.p_ObjectEnumerator=function(){
	return c_Enumerator3.m_new.call(new c_Enumerator3,this);
}
c_List3.prototype.p_Equals2=function(t_lhs,t_rhs){
	return t_lhs==t_rhs;
}
c_List3.prototype.p_RemoveEach2=function(t_value){
	var t_node=this.m__head.m__succ;
	while(t_node!=this.m__head){
		var t_succ=t_node.m__succ;
		if(this.p_Equals2(t_node.m__data,t_value)){
			t_node.p_Remove();
		}
		t_node=t_succ;
	}
	return 0;
}
function c_Node3(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node3.m_new=function(t_succ,t_pred,t_data){
	this.m__succ=t_succ;
	this.m__pred=t_pred;
	this.m__succ.m__pred=this;
	this.m__pred.m__succ=this;
	this.m__data=t_data;
	return this;
}
c_Node3.m_new2=function(){
	return this;
}
c_Node3.prototype.p_Remove=function(){
	this.m__succ.m__pred=this.m__pred;
	this.m__pred.m__succ=this.m__succ;
	return 0;
}
function c_HeadNode3(){
	c_Node3.call(this);
}
c_HeadNode3.prototype=extend_class(c_Node3);
c_HeadNode3.m_new=function(){
	c_Node3.m_new2.call(this);
	this.m__succ=(this);
	this.m__pred=(this);
	return this;
}
function c_Llama(){
	Object.call(this);
	this.m_spr=null;
	this.m_scale=null;
	this.m_vel=null;
}
c_Llama.m_list=null;
c_Llama.m_new=function(t_img,t_data,t__pos){
	this.m_spr=c_Sprite3D.m_new.call(new c_Sprite3D,t_img,t_data,true,false,true);
	this.m_spr.m_pos.p_Set5(t__pos);
	this.m_spr.m_pos.m_z=this.m_spr.m_pos.m_z-2.0;
	this.m_spr.m_ang+=bb_random_Rnd2(0.0,360.0);
	if(bb_random_Rnd2(1.0,100.0)<75.0){
		this.m_spr.m_blend=1;
	}
	this.m_spr.m_scale.p_Set(0.0,0.0);
	this.m_scale=c_Vec2.m_new.call(new c_Vec2,bb_random_Rnd2(0.005,0.02)*4.0,bb_random_Rnd2(0.005,0.02)*4.0);
	this.m_vel=c_Vec3.m_new.call(new c_Vec3,bb_random_Rnd2(-2.0,2.0),-bb_random_Rnd2(0.1,0.3)/1.0,bb_random_Rnd2(0.01,0.05));
	c_Llama.m_list.p_AddLast4(this);
	return this;
}
c_Llama.m_new2=function(){
	return this;
}
c_Llama.prototype.p_Update=function(){
	this.m_spr.p_Scalation(c_Vec3.m_new.call(new c_Vec3,1.0,1.0,1.0));
	this.m_spr.p_Rotation(c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0));
	this.m_spr.p_Translation(c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0));
	this.m_spr.p_Proyection();
	this.m_spr.m_scale.m_x+=(this.m_scale.m_x-this.m_spr.m_scale.m_x)/(15.0/c_Display.m_d);
	this.m_spr.m_scale.m_y+=(this.m_scale.m_y-this.m_spr.m_scale.m_y)/(15.0/c_Display.m_d);
	this.m_spr.m_ang+=this.m_vel.m_x*c_Display.m_d;
	this.m_spr.m_pos.m_y+=this.m_vel.m_y*c_Display.m_d;
	this.m_spr.m_a-=this.m_vel.m_z*c_Display.m_d;
	if(this.m_spr.m_a<=0.0){
		this.m_spr.p_Destroy();
		c_Llama.m_list.p_RemoveEach3(this);
	}
	return 0;
}
c_Llama.m_UpdateAll=function(){
	var t_=c_Llama.m_list.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.p_Update();
	}
	return 0;
}
function c_List4(){
	Object.call(this);
	this.m__head=(c_HeadNode4.m_new.call(new c_HeadNode4));
}
c_List4.m_new=function(){
	return this;
}
c_List4.prototype.p_AddLast4=function(t_data){
	return c_Node4.m_new.call(new c_Node4,this.m__head,this.m__head.m__pred,t_data);
}
c_List4.m_new2=function(t_data){
	var t_=t_data;
	var t_2=0;
	while(t_2<t_.length){
		var t_t=t_[t_2];
		t_2=t_2+1;
		this.p_AddLast4(t_t);
	}
	return this;
}
c_List4.prototype.p_ObjectEnumerator=function(){
	return c_Enumerator2.m_new.call(new c_Enumerator2,this);
}
c_List4.prototype.p_Equals3=function(t_lhs,t_rhs){
	return t_lhs==t_rhs;
}
c_List4.prototype.p_RemoveEach3=function(t_value){
	var t_node=this.m__head.m__succ;
	while(t_node!=this.m__head){
		var t_succ=t_node.m__succ;
		if(this.p_Equals3(t_node.m__data,t_value)){
			t_node.p_Remove();
		}
		t_node=t_succ;
	}
	return 0;
}
function c_Node4(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node4.m_new=function(t_succ,t_pred,t_data){
	this.m__succ=t_succ;
	this.m__pred=t_pred;
	this.m__succ.m__pred=this;
	this.m__pred.m__succ=this;
	this.m__data=t_data;
	return this;
}
c_Node4.m_new2=function(){
	return this;
}
c_Node4.prototype.p_Remove=function(){
	this.m__succ.m__pred=this.m__pred;
	this.m__pred.m__succ=this.m__succ;
	return 0;
}
function c_HeadNode4(){
	c_Node4.call(this);
}
c_HeadNode4.prototype=extend_class(c_Node4);
c_HeadNode4.m_new=function(){
	c_Node4.m_new2.call(this);
	this.m__succ=(this);
	this.m__pred=(this);
	return this;
}
function c_Enumerator2(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator2.m_new=function(t_list){
	this.m__list=t_list;
	this.m__curr=t_list.m__head.m__succ;
	return this;
}
c_Enumerator2.m_new2=function(){
	return this;
}
c_Enumerator2.prototype.p_HasNext=function(){
	while(this.m__curr.m__succ.m__pred!=this.m__curr){
		this.m__curr=this.m__curr.m__succ;
	}
	return this.m__curr!=this.m__list.m__head;
}
c_Enumerator2.prototype.p_NextObject=function(){
	var t_data=this.m__curr.m__data;
	this.m__curr=this.m__curr.m__succ;
	return t_data;
}
function c_Enumerator3(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator3.m_new=function(t_list){
	this.m__list=t_list;
	this.m__curr=t_list.m__head.m__succ;
	return this;
}
c_Enumerator3.m_new2=function(){
	return this;
}
c_Enumerator3.prototype.p_HasNext=function(){
	while(this.m__curr.m__succ.m__pred!=this.m__curr){
		this.m__curr=this.m__curr.m__succ;
	}
	return this.m__curr!=this.m__list.m__head;
}
c_Enumerator3.prototype.p_NextObject=function(){
	var t_data=this.m__curr.m__data;
	this.m__curr=this.m__curr.m__succ;
	return t_data;
}
function c_Coulds(){
	Object.call(this);
	this.m_obj=null;
	this.m_vel=[];
}
c_Coulds.m__DEPTH=0;
c_Coulds.prototype.p_ResetStar=function(t_o){
	var t_scale=bb_random_Rnd2(0.005,0.01)*7.0;
	t_o.m_pos.m_x=((bb_random_Rnd2(-50.0,50.0))|0);
	t_o.m_pos.m_y=bb_random_Rnd2(9.0,11.0);
	t_o.m_pos.m_z=(c_Coulds.m__DEPTH);
	t_o.m_scale.p_Set(t_scale,t_scale);
	return 0;
}
c_Coulds.m_new=function(t_img,t_data,t_sprScale,t_num){
	this.m_obj=c_Object3D.m_new.call(new c_Object3D,true,false,true);
	this.m_obj.m_pos.p_Set4(0.0,0.0,0.0);
	this.m_obj.m_ang.p_Add3(-4.0,0.0,0.0);
	this.m_vel=new_number_array(t_num);
	for(var t_n=0;t_n<t_num;t_n=t_n+1){
		this.m_vel[t_n]=bb_random_Rnd2(0.25,3.0)*0.25;
		this.m_vel[t_n]=0.125;
		var t_star=this.m_obj.p_InsertSprite(c_Vec3.m_new.call(new c_Vec3,0.0,0.0,0.0),t_img[((bb_random_Rnd2(0.0,(t_img.length)))|0)],t_data,t_sprScale);
		this.p_ResetStar(t_star);
		t_star.m_pos.m_z=((bb_random_Rnd2(0.0,(c_Coulds.m__DEPTH)))|0);
	}
	return this;
}
c_Coulds.m_new2=function(){
	return this;
}
c_Coulds.prototype.p_Update=function(){
	var t_cont=0;
	var t_=this.m_obj.m_sprite3DList.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.m_pos.m_z-=this.m_vel[t_cont]*c_Display.m_d;
		if(t_o.m_pos.m_z<=0.0){
			this.p_ResetStar(t_o);
		}
		t_o.m_a=1.0-bb_math_Abs2(t_o.m_pos.m_z)/(c_Coulds.m__DEPTH);
		t_cont+=1;
	}
	return 0;
}
function c_Tunnel(){
	Object.call(this);
	this.m_img=[];
	this.m_data=[];
	this.m_obj=null;
	this.m_timer=null;
	this.m_ang=.0;
	this.m_ang2=.0;
}
c_Tunnel.m_new=function(t_img,t_data){
	this.m_img=t_img;
	this.m_data=t_data;
	this.m_obj=c_Object3D.m_new.call(new c_Object3D,true,true,true);
	this.m_obj.m_pos.p_Set4(0.0,5.0,0.0);
	this.m_timer=c_Timer.m_new.call(new c_Timer,100);
	this.m_timer.p_Play();
	return this;
}
c_Tunnel.m_new2=function(){
	return this;
}
c_Tunnel.m__DEPTH=0;
c_Tunnel.prototype.p_NewBall=function(){
	var t_x=Math.cos((this.m_ang)*D2R)*10.0+Math.sin((-this.m_ang)*D2R)*5.0;
	var t_y=Math.sin((this.m_ang)*D2R)*10.0+Math.cos((-this.m_ang)*D2R)*5.0;
	this.m_ang=this.m_ang+18.0;
	this.m_obj.p_InsertSprite(c_Vec3.m_new.call(new c_Vec3,t_x,t_y,(c_Tunnel.m__DEPTH)),this.m_img[((bb_random_Rnd2(0.0,(this.m_img.length)))|0)],this.m_data,0.1);
	this.m_obj.p_InsertSprite(c_Vec3.m_new.call(new c_Vec3,t_y,t_x,(c_Tunnel.m__DEPTH)),this.m_img[((bb_random_Rnd2(0.0,(this.m_img.length)))|0)],this.m_data,0.1);
	return 0;
}
c_Tunnel.prototype.p_Update=function(){
	this.m_timer.p_Update();
	if(this.m_timer.m_tick){
		this.p_NewBall();
	}
	this.m_ang2-=.5*c_Display.m_d;
	this.m_obj.m_ang.p_Set4(0.0,0.0,this.m_ang2);
	var t_=this.m_obj.m_sprite3DList.p_ObjectEnumerator();
	while(t_.p_HasNext()){
		var t_o=t_.p_NextObject();
		t_o.m_pos.m_z-=1.0*c_Display.m_d;
		if(t_o.m_pos.m_z<=0.0){
			t_o.p_Destroy();
		}
	}
	return 0;
}
function c_Timer(){
	Object.call(this);
	this.m_milis=0;
	this.m_state=0;
	this.m_old_ms=0;
	this.m_ticks=0;
	this.m_tick=false;
}
c_Timer.prototype.p_Reset=function(){
	this.m_old_ms=bb_app_Millisecs();
	this.m_ticks=0;
	this.m_tick=false;
	return 0;
}
c_Timer.m_new=function(t_milis){
	this.m_milis=t_milis;
	this.m_state=0;
	this.p_Reset();
	return this;
}
c_Timer.m_new2=function(){
	return this;
}
c_Timer.prototype.p_Play=function(){
	if(this.m_state==0){
		this.p_Reset();
	}
	this.m_state=1;
	return 0;
}
c_Timer.prototype.p_Update=function(){
	if(this.m_tick==true){
		this.m_tick=false;
	}
	if(this.m_state==1){
		if(bb_app_Millisecs()-this.m_old_ms>=this.m_milis){
			this.m_old_ms=bb_app_Millisecs();
			this.m_ticks+=1;
			this.m_tick=true;
		}
	}
	return 0;
}
function c_Toro(){
	Object.call(this);
	this.m_obj=null;
	this.m_ang=.0;
}
c_Toro.m_new=function(){
	this.m_obj=c_Object3D.m_new2.call(new c_Object3D,c_Assets.m_obj_toro,c_Assets.m_img_bolahierro,c_Assets.m_data_64f,0.04,true,true,true);
	this.m_obj.m_size.p_Set4(1.5,1.5,1.5);
	return this;
}
c_Toro.prototype.p_Update=function(){
	this.m_obj.m_ang.p_Add3(-0.5*c_Display.m_d,0.25*c_Display.m_d,-0.125*c_Display.m_d);
	this.m_ang+=0.2*c_Display.m_d;
	this.m_obj.m_pos.p_Set4(Math.cos((this.m_ang)*D2R)*10.0,Math.sin((this.m_ang*2.0)*D2R)*10.0,40.0+Math.sin((this.m_ang)*D2R)*30.0);
	return 0;
}
function c_Parallax(){
	Object.call(this);
	this.m_scroll=[];
	this.m_creditsimg=[];
	this.m_ancho=.0;
	this.m_vel=[];
	this.m_pos=[];
	this.m_flare=null;
	this.m_credits=[];
}
c_Parallax.m_new=function(t_scroll,t_creditsimg){
	this.m_scroll=t_scroll;
	this.m_creditsimg=t_creditsimg;
	this.m_ancho=(t_scroll[0].p_Width());
	this.m_vel=new_number_array(t_scroll.length);
	this.m_pos=new_number_array(t_scroll.length);
	this.m_flare=c_Sprite.m_new2.call(new c_Sprite,c_Assets.m_img_flare);
	this.m_flare.m_pos.p_Set(130.0,160.0);
	this.m_flare.m_scale.p_Set(3.0,3.0);
	this.m_flare.m_a=0.25;
	this.m_flare.m_blend=1;
	this.m_credits[0]=640.0;
	this.m_credits[1]=740.0;
	this.m_credits[2]=840.0;
	this.m_vel[0]=0.05;
	this.m_vel[1]=this.m_vel[0]*2.0;
	this.m_vel[2]=this.m_vel[1]*2.0;
	this.m_vel[3]=this.m_vel[2]*2.0;
	this.m_vel[4]=this.m_vel[3]*2.0;
	return this;
}
c_Parallax.m_new2=function(){
	return this;
}
c_Parallax.prototype.p_Update=function(){
	for(var t_n=0;t_n<this.m_scroll.length;t_n=t_n+1){
		this.m_pos[t_n]-=this.m_vel[t_n]*c_Display.m_d;
		if(this.m_pos[t_n]<-this.m_ancho){
			this.m_pos[t_n]=0.0;
		}
	}
	this.m_flare.m_pos.p_Add(-this.m_vel[0],0.0);
	for(var t_n2=0;t_n2<3;t_n2=t_n2+1){
		this.m_credits[t_n2]-=this.m_vel[t_n2+1]*5.0*c_Display.m_d;
	}
	return 0;
}
c_Parallax.prototype.p_Draw=function(){
	for(var t_n=0;t_n<this.m_scroll.length;t_n=t_n+1){
		bb_graphics_DrawImage(this.m_scroll[t_n],this.m_pos[t_n],0.0,0);
		bb_graphics_DrawImage(this.m_scroll[t_n],this.m_pos[t_n]+this.m_ancho-1.0,0.0,0);
		if(t_n>0 && t_n<4){
			bb_graphics_DrawImage(this.m_creditsimg[t_n-1],this.m_credits[t_n-1],0.0,0);
		}
		if(t_n==2){
			this.m_flare.m_ang+=.1;
			this.m_flare.p_Draw();
		}
	}
	return 0;
}
function c_Sprite(){
	Object.call(this);
	this.m_data=[];
	this.m_img=null;
	this.m_scale=null;
	this.m_pos=null;
	this.m_pivot=null;
	this.m_frames=0;
	this.m_single=false;
	this.m_a=1.0;
	this.m_blend=0;
	this.m_ang=.0;
	this.m_frame=0.0;
}
c_Sprite.m_new=function(t_img,t_data){
	this.m_data=t_data;
	this.m_img=t_img;
	this.m_scale=c_Vec2.m_new.call(new c_Vec2,1.0,1.0);
	this.m_pos=c_Vec2.m_new.call(new c_Vec2,0.0,0.0);
	this.m_pivot=c_Vec2.m_new.call(new c_Vec2,(this.m_data[0][7])/2.0,(this.m_data[0][8])/2.0);
	this.m_frames=t_data.length;
	return this;
}
c_Sprite.m_new2=function(t_img){
	this.m_data=[[0,0,0,t_img.p_Width(),t_img.p_Height(),0,0,t_img.p_Width(),t_img.p_Height()]];
	this.m_data=this.m_data;
	this.m_single=true;
	this.m_img=t_img;
	this.m_scale=c_Vec2.m_new.call(new c_Vec2,1.0,1.0);
	this.m_pos=c_Vec2.m_new.call(new c_Vec2,0.0,0.0);
	this.m_pivot=c_Vec2.m_new.call(new c_Vec2,(t_img.p_Width())/2.0,(t_img.p_Height())/2.0);
	this.m_frames=this.m_data.length;
	this.m_frames=1;
	return this;
}
c_Sprite.m_new3=function(){
	return this;
}
c_Sprite.prototype.p_DrawSingle=function(){
	bb_graphics_PushMatrix();
	bb_graphics_Translate(this.m_pos.m_x,this.m_pos.m_y);
	bb_graphics_Rotate(this.m_ang);
	bb_graphics_Scale(this.m_scale.m_x,this.m_scale.m_y);
	bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
	bb_graphics_DrawImage(this.m_img,0.0,0.0,0);
	bb_graphics_PopMatrix();
	return 0;
}
c_Sprite.prototype.p_DrawComplex=function(){
	bb_graphics_PushMatrix();
	var t_f=((this.m_frame)|0);
	var t_1=this.m_data[t_f][0];
	if(t_1==-1){
		bb_graphics_Translate(this.m_pos.m_x+(this.m_data[t_f][5])+(this.m_data[t_f][3]),this.m_pos.m_y+(this.m_data[t_f][6]));
		bb_graphics_Rotate(this.m_ang-90.0);
		bb_graphics_Scale(this.m_scale.m_x,this.m_scale.m_y);
		bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
		bb_graphics_DrawImageRect(this.m_img,0.0,0.0,this.m_data[t_f][1],this.m_data[t_f][2],this.m_data[t_f][4],this.m_data[t_f][3],0);
	}else{
		if(t_1==0){
			bb_graphics_Translate(this.m_pos.m_x+(this.m_data[t_f][5]),this.m_pos.m_y+(this.m_data[t_f][6]));
			bb_graphics_Rotate(this.m_ang);
			bb_graphics_Scale(this.m_scale.m_x,this.m_scale.m_y);
			bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
			bb_graphics_DrawImageRect(this.m_img,0.0,0.0,this.m_data[t_f][1],this.m_data[t_f][2],this.m_data[t_f][3],this.m_data[t_f][4],0);
		}else{
			if(t_1==1){
				bb_graphics_Translate(this.m_pos.m_x+(this.m_data[t_f][5])+(this.m_data[t_f][4]),this.m_pos.m_y+(this.m_data[t_f][6]));
				bb_graphics_Rotate(this.m_ang-90.0);
				bb_graphics_Scale(this.m_scale.m_x,this.m_scale.m_y);
				bb_graphics_Translate(-this.m_pivot.m_x,-this.m_pivot.m_y);
				bb_graphics_DrawImageRect(this.m_img,0.0,0.0,this.m_data[t_f][1],this.m_data[t_f][2],this.m_data[t_f][3],this.m_data[t_f][4],0);
			}
		}
	}
	bb_graphics_PopMatrix();
	return 0;
}
c_Sprite.prototype.p_Draw=function(){
	bb_graphics_SetAlpha(this.m_a);
	bb_graphics_SetBlend(this.m_blend);
	if(this.m_single){
		this.p_DrawSingle();
	}else{
		this.p_DrawComplex();
	}
	bb_graphics_SetAlpha(1.0);
	bb_graphics_SetBlend(0);
	return 0;
}
function c_Enumerator4(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator4.m_new=function(t_list){
	this.m__list=t_list;
	this.m__curr=t_list.m__head.m__succ;
	return this;
}
c_Enumerator4.m_new2=function(){
	return this;
}
c_Enumerator4.prototype.p_HasNext=function(){
	while(this.m__curr.m__succ.m__pred!=this.m__curr){
		this.m__curr=this.m__curr.m__succ;
	}
	return this.m__curr!=this.m__list.m__head;
}
c_Enumerator4.prototype.p_NextObject=function(){
	var t_data=this.m__curr.m__data;
	this.m__curr=this.m__curr.m__succ;
	return t_data;
}
function bb_graphics_Transform(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	var t_ix2=t_ix*bb_graphics_context.m_ix+t_iy*bb_graphics_context.m_jx;
	var t_iy2=t_ix*bb_graphics_context.m_iy+t_iy*bb_graphics_context.m_jy;
	var t_jx2=t_jx*bb_graphics_context.m_ix+t_jy*bb_graphics_context.m_jx;
	var t_jy2=t_jx*bb_graphics_context.m_iy+t_jy*bb_graphics_context.m_jy;
	var t_tx2=t_tx*bb_graphics_context.m_ix+t_ty*bb_graphics_context.m_jx+bb_graphics_context.m_tx;
	var t_ty2=t_tx*bb_graphics_context.m_iy+t_ty*bb_graphics_context.m_jy+bb_graphics_context.m_ty;
	bb_graphics_SetMatrix(t_ix2,t_iy2,t_jx2,t_jy2,t_tx2,t_ty2);
	return 0;
}
function bb_graphics_Transform2(t_m){
	bb_graphics_Transform(t_m[0],t_m[1],t_m[2],t_m[3],t_m[4],t_m[5]);
	return 0;
}
function bb_graphics_Translate(t_x,t_y){
	bb_graphics_Transform(1.0,0.0,0.0,1.0,t_x,t_y);
	return 0;
}
function bb_graphics_Scale(t_x,t_y){
	bb_graphics_Transform(t_x,0.0,0.0,t_y,0.0,0.0);
	return 0;
}
function bb_graphics_Cls(t_r,t_g,t_b){
	bb_graphics_renderDevice.Cls(t_r,t_g,t_b);
	return 0;
}
function bb_graphics_DrawImage(t_image,t_x,t_y,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_context.p_Validate();
	if((t_image.m_flags&65536)!=0){
		bb_graphics_renderDevice.DrawSurface(t_image.m_surface,t_x-t_image.m_tx,t_y-t_image.m_ty);
	}else{
		bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,t_x-t_image.m_tx,t_y-t_image.m_ty,t_f.m_x,t_f.m_y,t_image.m_width,t_image.m_height);
	}
	return 0;
}
function bb_graphics_PushMatrix(){
	var t_sp=bb_graphics_context.m_matrixSp;
	bb_graphics_context.m_matrixStack[t_sp+0]=bb_graphics_context.m_ix;
	bb_graphics_context.m_matrixStack[t_sp+1]=bb_graphics_context.m_iy;
	bb_graphics_context.m_matrixStack[t_sp+2]=bb_graphics_context.m_jx;
	bb_graphics_context.m_matrixStack[t_sp+3]=bb_graphics_context.m_jy;
	bb_graphics_context.m_matrixStack[t_sp+4]=bb_graphics_context.m_tx;
	bb_graphics_context.m_matrixStack[t_sp+5]=bb_graphics_context.m_ty;
	bb_graphics_context.m_matrixSp=t_sp+6;
	return 0;
}
function bb_graphics_Rotate(t_angle){
	bb_graphics_Transform(Math.cos((t_angle)*D2R),-Math.sin((t_angle)*D2R),Math.sin((t_angle)*D2R),Math.cos((t_angle)*D2R),0.0,0.0);
	return 0;
}
function bb_graphics_PopMatrix(){
	var t_sp=bb_graphics_context.m_matrixSp-6;
	bb_graphics_SetMatrix(bb_graphics_context.m_matrixStack[t_sp+0],bb_graphics_context.m_matrixStack[t_sp+1],bb_graphics_context.m_matrixStack[t_sp+2],bb_graphics_context.m_matrixStack[t_sp+3],bb_graphics_context.m_matrixStack[t_sp+4],bb_graphics_context.m_matrixStack[t_sp+5]);
	bb_graphics_context.m_matrixSp=t_sp;
	return 0;
}
function bb_graphics_DrawImage2(t_image,t_x,t_y,t_rotation,t_scaleX,t_scaleY,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_PushMatrix();
	bb_graphics_Translate(t_x,t_y);
	bb_graphics_Rotate(t_rotation);
	bb_graphics_Scale(t_scaleX,t_scaleY);
	bb_graphics_Translate(-t_image.m_tx,-t_image.m_ty);
	bb_graphics_context.p_Validate();
	if((t_image.m_flags&65536)!=0){
		bb_graphics_renderDevice.DrawSurface(t_image.m_surface,0.0,0.0);
	}else{
		bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,0.0,0.0,t_f.m_x,t_f.m_y,t_image.m_width,t_image.m_height);
	}
	bb_graphics_PopMatrix();
	return 0;
}
function bb_graphics_DrawImageRect(t_image,t_x,t_y,t_srcX,t_srcY,t_srcWidth,t_srcHeight,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_context.p_Validate();
	bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,-t_image.m_tx+t_x,-t_image.m_ty+t_y,t_srcX+t_f.m_x,t_srcY+t_f.m_y,t_srcWidth,t_srcHeight);
	return 0;
}
function bb_graphics_DrawImageRect2(t_image,t_x,t_y,t_srcX,t_srcY,t_srcWidth,t_srcHeight,t_rotation,t_scaleX,t_scaleY,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_PushMatrix();
	bb_graphics_Translate(t_x,t_y);
	bb_graphics_Rotate(t_rotation);
	bb_graphics_Scale(t_scaleX,t_scaleY);
	bb_graphics_Translate(-t_image.m_tx,-t_image.m_ty);
	bb_graphics_context.p_Validate();
	bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,0.0,0.0,t_srcX+t_f.m_x,t_srcY+t_f.m_y,t_srcWidth,t_srcHeight);
	bb_graphics_PopMatrix();
	return 0;
}
function bbInit(){
	bb_app__app=null;
	bb_app__delegate=null;
	bb_app__game=BBGame.Game();
	bb_graphics_device=null;
	bb_graphics_context=c_GraphicsContext.m_new.call(new c_GraphicsContext);
	c_Image.m_DefaultFlags=0;
	bb_audio_device=null;
	bb_input_device=null;
	bb_graphics_renderDevice=null;
	c_Display.m_w=.0;
	c_Display.m_h=.0;
	c_Display.m_hz=60.0;
	c_Display.m_tFps=1.0;
	c_Display.m_dw=.0;
	c_Display.m_dh=.0;
	c_Display.m_s=.0;
	c_Display.m_ox=.0;
	c_Display.m_oy=.0;
	c_Display.m_scissorX=.0;
	c_Display.m_scissorY=.0;
	c_Display.m_scissorW=.0;
	c_Display.m_scissorH=.0;
	bb_app__updateRate=0;
	c_Display.m_old_ms=0;
	c_Display.m_ini_ms=0;
	c_Display.m_d=1.0;
	c_Display.m_fps=60;
	c_Display.m_realXMin=.0;
	c_Display.m_realYMin=.0;
	c_Display.m_realXMax=.0;
	c_Display.m_realYMax=.0;
	c_Display.m_realW=.0;
	c_Display.m_realH=.0;
	bb_random_Seed=1234;
	c_Camera3D.m_origin=null;
	c_Camera3D.m_dist=.0;
	c_Camera3D.m_near=.0;
	c_Camera3D.m_far=.0;
	c_Camera3D.m_focusDist=.0;
	c_Camera3D.m_focusLength=new_number_array(3);
	c_Assets.m_img_fire=new_object_array(6);
	c_Assets.m_img_chispa=null;
	c_Assets.m_img_nube=new_object_array(5);
	c_Assets.m_img_bgnubes=null;
	c_Assets.m_img_bgfuego=null;
	c_Assets.m_img_burbuja=null;
	c_Assets.m_img_bgburbuja=null;
	c_Assets.m_img_bolahierro=null;
	c_Assets.m_img_bolafire=null;
	c_Assets.m_img_frame=new_object_array(4);
	c_Assets.m_img_parallax=new_object_array(5);
	c_Assets.m_img_bolaacero=new_object_array(3);
	c_Assets.m_img_bgbolaacero=null;
	c_Assets.m_txt_icevan=null;
	c_Assets.m_txt_kba=null;
	c_Assets.m_txt_illl=null;
	c_Assets.m_txt_titulo=null;
	c_Assets.m_txt_purple=null;
	c_Assets.m_txt_mouse=null;
	c_Assets.m_txt_euskal=null;
	c_Assets.m_img_flare=null;
	c_Demo.m_estado="start";
	c_Assets.m_data_64f=[[0,0,0,64,64,0,0,64,64],[0,64,0,64,64,0,0,64,64],[0,128,0,64,64,0,0,64,64],[0,192,0,64,64,0,0,64,64]];
	c_Object3D.m_list=c_List.m_new.call(new c_List);
	c_Sprite3D.m_list=c_Sprite3DList.m_new.call(new c_Sprite3DList);
	c_StarField.m__RAD=100;
	c_StarField.m__DEPTH=200;
	c_Display.m_t=0;
	c_Assets.m_obj_fireball="v -4 0 5.61539e-7/v -3.4026 1.78885 -1.10557/v -3.4026 -1.78885 1.10557/v -3.23607 0 -2.35114/v -3.23607 -2.10292 -1.05146/v -3.23607 0 2.35114/v -3.23607 2.10292 1.05146/v -2.10292 -1.78885 -2.89443/v -2.10292 1.78885 2.89443/v -2 2.10292 -2.75276/v -2 3.4026 -0.649839/v -2 -3.4026 0.64984/v -2 -2.10292 2.75276/v -1.23607 0 -3.80423/v -1.23607 -3.4026 -1.7013/v -1.23607 3.4026 1.7013/v -1.23607 0 3.80423/v -3.18449e-7 -2.10292 -3.4026/v 0 -4 0/v 0 1.78885 -3.57771/v 0 3.4026 -2.10292/v 0 4 0/v 1.96812e-7 -3.4026 2.10292/v 3.18449e-7 2.10292 3.4026/v 3.34837e-7 -1.78885 3.57771/v 1.23607 -3.4026 -1.7013/v 1.23607 0 -3.80423/v 1.23607 3.4026 1.7013/v 1.23607 0 3.80423/v 2 -3.4026 0.649839/v 2 2.10292 -2.75276/v 2 3.4026 -0.649839/v 2 -2.10292 2.75276/v 2.10292 -1.78885 -2.89443/v 2.10292 1.78885 2.89443/v 3.23607 -2.10292 -1.05146/v 3.23607 2.10292 1.05146/v 3.23607 0 -2.35114/v 3.23607 0 2.35114/v 3.4026 -1.78885 1.10557/v 3.4026 1.78885 -1.10557/v 4 0 -1.8718e-7/";
	c_Assets.m_data_128=[[0,0,0,128,128,0,0,128,128]];
	c_Assets.m_data_8=[[0,0,0,8,8,0,0,8,8]];
	c_Chispa.m_list=c_List3.m_new.call(new c_List3);
	c_Llama.m_list=c_List4.m_new.call(new c_List4);
	c_Assets.m_data_512=[[0,0,0,512,512,0,0,512,512]];
	c_Coulds.m__DEPTH=200;
	c_Tunnel.m__DEPTH=300;
	c_Assets.m_obj_toro="v -6 0 7.34788e-16/v -5.41421 -1.41421 6.6305e-16/v -5.41421 1.41421 6.6305e-16/v -4.24264 0 4.24264/v -4.24264 0 -4.24264/v -4 -2 4.89859e-16/v -4 2 4.89859e-16/v -3.82843 -1.41421 3.82843/v -3.82843 -1.41421 -3.82843/v -3.82843 1.41421 3.82843/v -3.82843 1.41421 -3.82843/v -2.82843 -2 2.82843/v -2.82843 -2 -2.82843/v -2.82843 2 2.82843/v -2.82843 2 -2.82843/v -2.58579 -1.41421 3.16668e-16/v -2.58579 1.41421 3.16668e-16/v -2 0 2.44929e-16/v -1.82843 -1.41421 1.82843/v -1.82843 -1.41421 -1.82843/v -1.82843 1.41421 1.82843/v -1.82843 1.41421 -1.82843/v -1.41421 0 1.41421/v -1.41421 0 -1.41421/v -1.10218e-15 0 -6/v -9.94575e-16 -1.41421 -5.41421/v -9.94575e-16 1.41421 -5.41421/v -7.34788e-16 -2 -4/v -7.34788e-16 2 -4/v -4.75001e-16 -1.41421 -2.58579/v -4.75001e-16 1.41421 -2.58579/v -3.67394e-16 0 -2/v 1.22465e-16 0 2/v 1.58334e-16 -1.41421 2.58579/v 1.58334e-16 1.41421 2.58579/v 2.44929e-16 -2 4/v 2.44929e-16 2 4/v 3.31525e-16 -1.41421 5.41421/v 3.31525e-16 1.41421 5.41421/v 3.67394e-16 0 6/v 1.41421 0 1.41421/v 1.41421 0 -1.41421/v 1.82843 -1.41421 1.82843/v 1.82843 -1.41421 -1.82843/v 1.82843 1.41421 1.82843/v 1.82843 1.41421 -1.82843/v 2 0 0/v 2.58579 -1.41421 0/v 2.58579 1.41421 0/v 2.82843 -2 2.82843/v 2.82843 -2 -2.82843/v 2.82843 2 2.82843/v 2.82843 2 -2.82843/v 3.82843 -1.41421 3.82843/v 3.82843 -1.41421 -3.82843/v 3.82843 1.41421 3.82843/v 3.82843 1.41421 -3.82843/v 4 -2 0/v 4 2 0/v 4.24264 0 4.24264/v 4.24264 0 -4.24264/v 5.41421 -1.41421 0/v 5.41421 1.41421 0/v 6 0 0/";
	c_Display.m_renders=0;
	c_Display.m_milis=0;
	c_Display.m_secs=0;
}
//${TRANSCODE_END}
